/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.field.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.field.Field;
import net.sourceforge.javadpkg.field.impl.FieldParserImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.io.DataSource;
import org.junit.Assert;
import org.junit.Test;

public class FieldParserImplTest
extends AbstractDpkgTest {
    @Test
    public void testParseFieldsAsList() {
        List fields;
        ContextImpl context = new ContextImpl();
        DataSource source = FieldParserImplTest.createSource(Arrays.asList("Package: mypackage", "Version: 1.0.0", "Section: net", "Priority: optional", "Architecture: amd64", "Depends: oracle-8-jre (>= 1.8.0)", "Installed-Size: 12345", "Homepage: http://www.example.com/", "Maintainer: John Doe <j.doe@example.com>", "Description: This is my first package.", " I'm somewhat excited.", " .", " This will be a great package.", " .", ""), "control");
        FieldParserImpl parser = new FieldParserImpl(false, false, false);
        try {
            fields = parser.parseFieldsAsList(null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            fields = parser.parseFieldsAsList(source, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            fields = parser.parseFieldsAsList(source, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)fields);
        Assert.assertEquals((long)10L, (long)fields.size());
        Field field = (Field)fields.get(0);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Package", (Object)field.getName());
        Assert.assertEquals((Object)"mypackage", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get(1);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Version", (Object)field.getName());
        Assert.assertEquals((Object)"1.0.0", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get(2);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Section", (Object)field.getName());
        Assert.assertEquals((Object)"net", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get(3);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Priority", (Object)field.getName());
        Assert.assertEquals((Object)"optional", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get(4);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Architecture", (Object)field.getName());
        Assert.assertEquals((Object)"amd64", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get(5);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Depends", (Object)field.getName());
        Assert.assertEquals((Object)"oracle-8-jre (>= 1.8.0)", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get(6);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Installed-Size", (Object)field.getName());
        Assert.assertEquals((Object)"12345", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get(7);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Homepage", (Object)field.getName());
        Assert.assertEquals((Object)"http://www.example.com/", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get(8);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Maintainer", (Object)field.getName());
        Assert.assertEquals((Object)"John Doe <j.doe@example.com>", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get(9);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Description", (Object)field.getName());
        Assert.assertEquals((Object)"This is my first package.\nI'm somewhat excited.\n.\nThis will be a great package.\n.", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        parser = new FieldParserImpl(true, false, false);
        source = FieldParserImplTest.createSource(Arrays.asList("Field1: value1", "", "Field2: value2", ""), "fields");
        try {
            fields = parser.parseFieldsAsList(source, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)fields);
        Assert.assertEquals((long)2L, (long)fields.size());
        field = (Field)fields.get(0);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Field1", (Object)field.getName());
        Assert.assertEquals((Object)"value1", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get(1);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Field2", (Object)field.getName());
        Assert.assertEquals((Object)"value2", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        parser = new FieldParserImpl(true, true, false);
        source = FieldParserImplTest.createSource(Arrays.asList("Field1: value1", "", "Field2: value2", ""), "fields");
        try {
            fields = parser.parseFieldsAsList(source, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)fields);
        Assert.assertEquals((long)4L, (long)fields.size());
        field = (Field)fields.get(0);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Field1", (Object)field.getName());
        Assert.assertEquals((Object)"value1", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get(1);
        Assert.assertNotNull((Object)field);
        Assert.assertNull((Object)field.getName());
        Assert.assertNull((Object)field.getValue());
        Assert.assertTrue((boolean)field.isEmpty());
        field = (Field)fields.get(2);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Field2", (Object)field.getName());
        Assert.assertEquals((Object)"value2", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get(3);
        Assert.assertNotNull((Object)field);
        Assert.assertNull((Object)field.getName());
        Assert.assertNull((Object)field.getValue());
        Assert.assertTrue((boolean)field.isEmpty());
    }

    @Test
    public void testParseFieldsAsMap() {
        Map fields;
        ContextImpl context = new ContextImpl();
        DataSource source = FieldParserImplTest.createSource(Arrays.asList("Package: mypackage", "Version: 1.0.0", "Section: net", "Priority: optional", "Architecture: amd64", "Depends: oracle-8-jre (>=1.8.0)", "Installed-Size: 12345", "Homepage: http://www.example.com/", "Maintainer: John Doe <j.doe@example.com>", "Description: This is my first package.", " I'm somewhat excited.", " .", " This will be a great package.", " .", ""), "control");
        FieldParserImpl parser = new FieldParserImpl(false, false, false);
        try {
            fields = parser.parseFieldsAsMap(null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            fields = parser.parseFieldsAsMap(source, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            fields = parser.parseFieldsAsMap(source, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)fields);
        Assert.assertEquals((long)10L, (long)fields.size());
        Field field = (Field)fields.get("package");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Package", (Object)field.getName());
        Assert.assertEquals((Object)"mypackage", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get("version");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Version", (Object)field.getName());
        Assert.assertEquals((Object)"1.0.0", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get("section");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Section", (Object)field.getName());
        Assert.assertEquals((Object)"net", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get("priority");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Priority", (Object)field.getName());
        Assert.assertEquals((Object)"optional", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get("architecture");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Architecture", (Object)field.getName());
        Assert.assertEquals((Object)"amd64", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get("depends");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Depends", (Object)field.getName());
        Assert.assertEquals((Object)"oracle-8-jre (>=1.8.0)", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get("installed-size");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Installed-Size", (Object)field.getName());
        Assert.assertEquals((Object)"12345", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get("homepage");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Homepage", (Object)field.getName());
        Assert.assertEquals((Object)"http://www.example.com/", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get("maintainer");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Maintainer", (Object)field.getName());
        Assert.assertEquals((Object)"John Doe <j.doe@example.com>", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get("description");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Description", (Object)field.getName());
        Assert.assertEquals((Object)"This is my first package.\nI'm somewhat excited.\n.\nThis will be a great package.\n.", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        parser = new FieldParserImpl(true, false, false);
        source = FieldParserImplTest.createSource(Arrays.asList("Field1: value1", "", "Field2: value2", ""), "fields");
        try {
            fields = parser.parseFieldsAsMap(source, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)fields);
        Assert.assertEquals((long)2L, (long)fields.size());
        field = (Field)fields.get("field1");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Field1", (Object)field.getName());
        Assert.assertEquals((Object)"value1", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get("field2");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Field2", (Object)field.getName());
        Assert.assertEquals((Object)"value2", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        parser = new FieldParserImpl(true, true, false);
        source = FieldParserImplTest.createSource(Arrays.asList("Field1: value1", "", "Field2: value2", ""), "fields");
        try {
            fields = parser.parseFieldsAsMap(source, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)fields);
        Assert.assertEquals((long)2L, (long)fields.size());
        field = (Field)fields.get("field1");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Field1", (Object)field.getName());
        Assert.assertEquals((Object)"value1", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
        field = (Field)fields.get("field2");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Field2", (Object)field.getName());
        Assert.assertEquals((Object)"value2", (Object)field.getValue());
        Assert.assertFalse((boolean)field.isEmpty());
    }
}

