/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.BinaryControl;
import net.sourceforge.javadpkg.control.Control;
import net.sourceforge.javadpkg.control.PackageDependency;
import net.sourceforge.javadpkg.control.impl.ControlParserImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.io.DataSource;
import org.junit.Assert;
import org.junit.Test;

public class ControlParserImplTest
extends AbstractDpkgTest {
    @Test
    public void test() {
        Control control;
        ControlParserImpl parser = new ControlParserImpl();
        DataSource source = ControlParserImplTest.createSource(Arrays.asList("Package: mypackage", "Version: 1.0.0", "Section: net", "Priority: optional", "Architecture: amd64", "Depends: oracle-8-jre (>= 1.8.0)", "Installed-Size: 12345", "Homepage: http://www.example.com/", "Maintainer: John Doe <j.doe@example.com>", "Description: This is my first package.", " I'm somewhat excited.", " .", " This will be a great package.", " .\n"), "control");
        ContextImpl context = new ContextImpl();
        try {
            parser.parseControl(null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            parser.parseControl(source, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            control = parser.parseControl(source, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)control);
        Assert.assertTrue((String)control.getClass().getCanonicalName(), (boolean)(control instanceof BinaryControl));
        BinaryControl binaryControl = (BinaryControl)control;
        Assert.assertNotNull((Object)binaryControl.getPackage());
        Assert.assertEquals((Object)"mypackage", (Object)binaryControl.getPackage().getName());
        Assert.assertNull((Object)binaryControl.getSource());
        Assert.assertNotNull((Object)binaryControl.getVersion());
        Assert.assertNull((Object)binaryControl.getVersion().getEpoch());
        Assert.assertEquals((Object)"1.0.0", (Object)binaryControl.getVersion().getUpstreamVersion());
        Assert.assertNull((Object)binaryControl.getVersion().getDebianRevision());
        Assert.assertEquals((Object)"1.0.0", (Object)binaryControl.getVersion().getText());
        Assert.assertNotNull((Object)binaryControl.getSection());
        Assert.assertEquals((Object)"net", (Object)binaryControl.getSection().getText());
        Assert.assertNotNull((Object)binaryControl.getPriority());
        Assert.assertEquals((Object)"optional", (Object)binaryControl.getPriority().getText());
        Assert.assertNotNull((Object)binaryControl.getArchitecture());
        Assert.assertEquals((Object)"amd64", (Object)binaryControl.getArchitecture().getText());
        Assert.assertNull((Object)binaryControl.getMultiArchitecture());
        Assert.assertNull((Object)binaryControl.getEssential());
        List dependencies = binaryControl.getDepends();
        Assert.assertNotNull((Object)dependencies);
        Assert.assertEquals((long)1L, (long)dependencies.size());
        PackageDependency dependency = (PackageDependency)dependencies.get(0);
        Assert.assertNotNull((Object)dependency);
        Assert.assertFalse((boolean)dependency.isCondition());
        Assert.assertNotNull((Object)dependency.getPackage());
        Assert.assertEquals((Object)"oracle-8-jre", (Object)dependency.getPackage().getName());
        Assert.assertNotNull((Object)dependency.getRelationOperator());
        Assert.assertEquals((Object)">=", (Object)dependency.getRelationOperator().getText());
        Assert.assertNotNull((Object)dependency.getVersion());
        Assert.assertNull((Object)dependency.getVersion().getEpoch());
        Assert.assertEquals((Object)"1.8.0", (Object)dependency.getVersion().getUpstreamVersion());
        Assert.assertNull((Object)dependency.getVersion().getDebianRevision());
        Assert.assertEquals((Object)"1.8.0", (Object)dependency.getVersion().getText());
        dependencies = binaryControl.getRecommends();
        Assert.assertNotNull((Object)dependencies);
        Assert.assertEquals((long)0L, (long)dependencies.size());
        dependencies = binaryControl.getSuggests();
        Assert.assertNotNull((Object)dependencies);
        Assert.assertEquals((long)0L, (long)dependencies.size());
        dependencies = binaryControl.getEnhances();
        Assert.assertNotNull((Object)dependencies);
        Assert.assertEquals((long)0L, (long)dependencies.size());
        dependencies = binaryControl.getPreDepends();
        Assert.assertNotNull((Object)dependencies);
        Assert.assertEquals((long)0L, (long)dependencies.size());
        dependencies = binaryControl.getBreaks();
        Assert.assertNotNull((Object)dependencies);
        Assert.assertEquals((long)0L, (long)dependencies.size());
        dependencies = binaryControl.getConflicts();
        Assert.assertNotNull((Object)dependencies);
        Assert.assertEquals((long)0L, (long)dependencies.size());
        dependencies = binaryControl.getProvides();
        Assert.assertNotNull((Object)dependencies);
        Assert.assertEquals((long)0L, (long)dependencies.size());
        dependencies = binaryControl.getReplaces();
        Assert.assertNotNull((Object)dependencies);
        Assert.assertEquals((long)0L, (long)dependencies.size());
        dependencies = binaryControl.getBuiltUsing();
        Assert.assertNotNull((Object)dependencies);
        Assert.assertEquals((long)0L, (long)dependencies.size());
        Assert.assertNotNull((Object)binaryControl.getInstalledSize());
        Assert.assertEquals((long)12641280L, (long)binaryControl.getInstalledSize().getBytes());
        Assert.assertNotNull((Object)binaryControl.getMaintainer());
        Assert.assertEquals((Object)"John Doe", (Object)binaryControl.getMaintainer().getName());
        Assert.assertEquals((Object)"j.doe@example.com", (Object)binaryControl.getMaintainer().getAddress());
        Assert.assertNull((Object)binaryControl.getOriginalMaintainer());
        Assert.assertNull((Object)binaryControl.getModuleAliases());
        Assert.assertNotNull((Object)binaryControl.getDescription());
        Assert.assertEquals((Object)"This is my first package.\nI'm somewhat excited.\n\nThis will be a great package.\n", (Object)binaryControl.getDescription().getText());
        Assert.assertNotNull((Object)binaryControl.getHomepage());
        Assert.assertNotNull((Object)binaryControl.getHomepage().getURL());
        Assert.assertEquals((Object)"http://www.example.com/", (Object)binaryControl.getHomepage().getURL().toString());
    }
}

