/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.control.Control;
import net.sourceforge.javadpkg.control.impl.BinaryControlImpl;
import net.sourceforge.javadpkg.control.impl.ControlBuilderImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.impl.DataStreamTarget;
import org.junit.Assert;
import org.junit.Test;

public class ControlBuilderImplTest
extends AbstractDpkgTest {
    @Test
    public void testBuildControlControlDataTargetContext() {
        ControlBuilderImpl builder = new ControlBuilderImpl();
        ContextImpl context = new ContextImpl();
        BinaryControlImpl control = ControlBuilderImplTest.createBinaryControl("mypackage", "1.0.0", "net", "optional", "amd64", "oracle-8-jre (>= 1.8.0)", 12345L, "http://www.example.com/", "John Doe <j.doe@example.com>", "This is my first package.\nI'm somewhat excited.\n.\nThis will be a great package.\n.");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataStreamTarget target = new DataStreamTarget((OutputStream)out, "control", false);
        context = new ContextImpl();
        try {
            builder.buildControl(null, (DataTarget)target, (Context)context);
            Assert.fail((String)"Expected an exception, but none wa thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            builder.buildControl((Control)control, null, (Context)context);
            Assert.fail((String)"Expected an exception, but none wa thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            builder.buildControl((Control)control, (DataTarget)target, null);
            Assert.fail((String)"Expected an exception, but none wa thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            builder.buildControl((Control)control, (DataTarget)target, (Context)context);
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        Assert.assertEquals((Object)"Package: mypackage\nVersion: 1.0.0\nArchitecture: amd64\nSection: net\nPriority: optional\nDepends: oracle-8-jre (>= 1.8.0)\nInstalled-Size: 12345\nMaintainer: John Doe <j.doe@example.com>\nHomepage: http://www.example.com/\nDescription: This is my first package.\n I'm somewhat excited.\n .\n This will be a great package.\n .\n", (Object)new String(out.toByteArray()));
    }
}

