/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.sourceforge.javadpkg.ChangeLogUrgency;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackageMaintainer;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageNameParser;
import net.sourceforge.javadpkg.control.PackageVersion;
import net.sourceforge.javadpkg.control.PackageVersionParser;
import net.sourceforge.javadpkg.control.PackageVersionRelationOperatorParser;
import net.sourceforge.javadpkg.control.Size;
import net.sourceforge.javadpkg.control.impl.ArchitectureParserImpl;
import net.sourceforge.javadpkg.control.impl.BinaryControlImpl;
import net.sourceforge.javadpkg.control.impl.DescriptionParserImpl;
import net.sourceforge.javadpkg.control.impl.HomepageParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageDependencyParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageMaintainerParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageNameParserImpl;
import net.sourceforge.javadpkg.control.impl.PackagePriorityParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionRelationOperatorParserImpl;
import net.sourceforge.javadpkg.control.impl.SectionParserImpl;
import net.sourceforge.javadpkg.impl.ChangeLogUrgencyParserImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.impl.DataByteArraySource;
import org.apache.commons.logging.impl.SimpleLog;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class AbstractDpkgTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Properties props = System.getProperties();
        props.setProperty("org.apache.commons.logging.Log", SimpleLog.class.getCanonicalName());
        props.setProperty("org.apache.commons.logging.simplelog.defaultlog", "trace");
        props.setProperty("org.apache.commons.logging.simplelog.showlogname", "true");
        props.setProperty("org.apache.commons.logging.simplelog.showShortLogname", "false");
        props.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        props.setProperty("org.apache.commons.logging.simplelog.dateTimeFormat", "yyyy-MM-dd HH:mm:ss.SSS");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Properties props = System.getProperties();
        props.remove("org.apache.commons.logging.Log");
        props.remove("org.apache.commons.logging.simplelog.defaultlog");
        props.remove("org.apache.commons.logging.simplelog.showlogname");
        props.remove("org.apache.commons.logging.simplelog.showShortLogname");
        props.remove("org.apache.commons.logging.simplelog.showdatetime");
        props.remove("org.apache.commons.logging.simplelog.dateTimeFormat");
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    public static DataSource createSource(int length, String name) {
        Assert.assertTrue((length >= 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)name);
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        byte[] buffer = new byte[65536];
        int rest = length;
        do {
            int len;
            if ((len = rest) > buffer.length) {
                len = buffer.length;
            }
            rest -= len;
            if (len <= 0) continue;
            out.write(buffer, 0, len);
        } while (rest > 0);
        DataByteArraySource source = new DataByteArraySource(out.toByteArray(), name, false, true);
        return source;
    }

    public static DataSource createSource(String lines, String name) {
        Assert.assertNotNull((Object)lines);
        Assert.assertNotNull((Object)name);
        DataSource source = AbstractDpkgTest.createSource(Arrays.asList(lines), name);
        return source;
    }

    public static DataSource createSource(List<String> lines, String name) {
        Assert.assertNotNull(lines);
        Assert.assertNotNull((Object)name);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream((OutputStream)out, false, "UTF-8");){
            for (String line : lines) {
                ps.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't prepare source |" + name + "|: " + e.getMessage()));
            return null;
        }
        DataByteArraySource source = new DataByteArraySource(out.toByteArray(), name, false, true);
        return source;
    }

    public static BinaryControlImpl createBinaryControl(String name, String version, String section, String priority, String architecture, String dependencies, Long installedSizeInKiloBytes, String homepage, String maintainer, String description) {
        Assert.assertNotNull((Object)name);
        Assert.assertNotNull((Object)version);
        Assert.assertNotNull((Object)architecture);
        Assert.assertNotNull((Object)maintainer);
        Assert.assertNotNull((Object)description);
        ContextImpl context = new ContextImpl();
        BinaryControlImpl control = new BinaryControlImpl();
        PackageNameParserImpl packageNameParser = new PackageNameParserImpl();
        PackageVersionParserImpl packageVersionParser = new PackageVersionParserImpl();
        try {
            control.setPackage(packageNameParser.parsePackageName(name, (Context)context));
            control.setVersion(packageVersionParser.parsePackageVersion(version, (Context)context));
            control.setSection(new SectionParserImpl().parseSection(section, (Context)context));
            control.setPriority(new PackagePriorityParserImpl().parsePackagePriority(priority, (Context)context));
            control.setArchitecture(new ArchitectureParserImpl().parseArchitecture(architecture, (Context)context));
            control.setDepends(new PackageDependencyParserImpl((PackageNameParser)packageNameParser, (PackageVersionRelationOperatorParser)new PackageVersionRelationOperatorParserImpl(), (PackageVersionParser)packageVersionParser).parsePackageDependencies(dependencies, (Context)context));
            if (installedSizeInKiloBytes != null) {
                control.setInstalledSize(Size.getSizeInKiloBytes((long)installedSizeInKiloBytes));
            }
            control.setHomepage(new HomepageParserImpl().parseHomepage(homepage, (Context)context));
            control.setMaintainer(new PackageMaintainerParserImpl().parsePackageMaintainer(maintainer, (Context)context));
            control.setDescription(new DescriptionParserImpl().parseDescription(description, (Context)context));
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't prepare control: " + e.getMessage()));
            return null;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((String)("Couldn't create binary control: Got " + warnings.size() + " warning(s)."), (long)0L, (long)warnings.size());
        return control;
    }

    public static PackageName createPackageName(String value) {
        PackageName name;
        Assert.assertNotNull((Object)value);
        PackageNameParserImpl packageNameParser = new PackageNameParserImpl();
        ContextImpl context = new ContextImpl();
        try {
            name = packageNameParser.parsePackageName(value, (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't parse package name |" + value + "|: " + e.getMessage()));
            return null;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((String)("Couldn't create package name |" + value + "|: Got " + warnings.size() + " warning(s)."), (long)0L, (long)warnings.size());
        return name;
    }

    public static PackageVersion createPackageVersion(String value) {
        PackageVersion name;
        Assert.assertNotNull((Object)value);
        PackageVersionParserImpl packageVersionParser = new PackageVersionParserImpl();
        ContextImpl context = new ContextImpl();
        try {
            name = packageVersionParser.parsePackageVersion(value, (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't parse package version |" + value + "|: " + e.getMessage()));
            return null;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((String)("Couldn't create package version |" + value + "|: Got " + warnings.size() + " warning(s)."), (long)0L, (long)warnings.size());
        return name;
    }

    public static PackageMaintainer createPackageMaintainer(String value) {
        PackageMaintainer maintainer;
        Assert.assertNotNull((Object)value);
        PackageMaintainerParserImpl packageMaintainerParser = new PackageMaintainerParserImpl();
        ContextImpl context = new ContextImpl();
        try {
            maintainer = packageMaintainerParser.parsePackageMaintainer(value, (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't parse package maintainer |" + value + "|: " + e.getMessage()));
            return null;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((String)("Couldn't create package maintainer |" + value + "|: Got " + warnings.size() + " warning(s)."), (long)0L, (long)warnings.size());
        return maintainer;
    }

    public static ChangeLogUrgency createChangeLogUrgency(String value) {
        ChangeLogUrgency urgency;
        Assert.assertNotNull((Object)value);
        ChangeLogUrgencyParserImpl urgencyParser = new ChangeLogUrgencyParserImpl();
        ContextImpl context = new ContextImpl();
        try {
            urgency = urgencyParser.parseChangeLogUrgency(value, (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't parse change log urgency |" + value + "|: " + e.getMessage()));
            return null;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((String)("Couldn't create change log urgency |" + value + "|: Got " + warnings.size() + " warning(s)."), (long)0L, (long)warnings.size());
        return urgency;
    }
}

