/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.io.impl;

import org.junit.Assert;
import org.junit.Test;

import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.io.FileMode;


/**
 * <p>
 * Performs some tests on the {@link FileModeImpl} class.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 12.05.2016 by Gerrit Hohl
 */
public class FileModeImplTest extends AbstractDpkgTest {
	
	
	/**
	 * <p>
	 * Performs some tests on the {@link FileModeImpl} class.
	 * </p>
	 */
	@Test
	public void test() {
		FileMode mode;
		
		
		// --- Parameters ---
		try {
			mode = new FileModeImpl(-1);
			Assert.fail("Expected an exception, but none was thrown.");
			return;
		} catch (IllegalArgumentException e) {
			// --- Expected exception. Do nothing. ---
		}
		try {
			mode = new FileModeImpl(01000000);
			Assert.fail("Expected an exception, but none was thrown.");
			return;
		} catch (IllegalArgumentException e) {
			// --- Expected exception. Do nothing. ---
		}
		
		
		// --- Different modes ---
		mode = new FileModeImpl(00000);
		Assert.assertEquals(00000, mode.getMode());
		Assert.assertEquals("000", mode.getOctal());
		Assert.assertEquals("---------", mode.getText());
		Assert.assertEquals(0, mode.getStickyBit());
		Assert.assertFalse(mode.isOwnerReadable());
		Assert.assertFalse(mode.isOwnerWriteable());
		Assert.assertFalse(mode.isOwnerExecutable());
		Assert.assertFalse(mode.isGroupReadable());
		Assert.assertFalse(mode.isGroupWriteable());
		Assert.assertFalse(mode.isGroupExecutable());
		Assert.assertFalse(mode.isOtherReadable());
		Assert.assertFalse(mode.isOtherWriteable());
		Assert.assertFalse(mode.isOtherExecutable());

		mode = new FileModeImpl(07777);
		Assert.assertEquals(07777, mode.getMode());
		Assert.assertEquals("777", mode.getOctal());
		Assert.assertEquals("rwxrwxrwx", mode.getText());
		Assert.assertEquals(7, mode.getStickyBit());
		Assert.assertTrue(mode.isOwnerReadable());
		Assert.assertTrue(mode.isOwnerWriteable());
		Assert.assertTrue(mode.isOwnerExecutable());
		Assert.assertTrue(mode.isGroupReadable());
		Assert.assertTrue(mode.isGroupWriteable());
		Assert.assertTrue(mode.isGroupExecutable());
		Assert.assertTrue(mode.isOtherReadable());
		Assert.assertTrue(mode.isOtherWriteable());
		Assert.assertTrue(mode.isOtherExecutable());

		mode = new FileModeImpl(00755);
		Assert.assertEquals(00755, mode.getMode());
		Assert.assertEquals("755", mode.getOctal());
		Assert.assertEquals("rwxr-xr-x", mode.getText());
		Assert.assertEquals(0, mode.getStickyBit());
		Assert.assertTrue(mode.isOwnerReadable());
		Assert.assertTrue(mode.isOwnerWriteable());
		Assert.assertTrue(mode.isOwnerExecutable());
		Assert.assertTrue(mode.isGroupReadable());
		Assert.assertFalse(mode.isGroupWriteable());
		Assert.assertTrue(mode.isGroupExecutable());
		Assert.assertTrue(mode.isOtherReadable());
		Assert.assertFalse(mode.isOtherWriteable());
		Assert.assertTrue(mode.isOtherExecutable());

		mode = new FileModeImpl(00644);
		Assert.assertEquals(00644, mode.getMode());
		Assert.assertEquals("644", mode.getOctal());
		Assert.assertEquals("rw-r--r--", mode.getText());
		Assert.assertEquals(0, mode.getStickyBit());
		Assert.assertTrue(mode.isOwnerReadable());
		Assert.assertTrue(mode.isOwnerWriteable());
		Assert.assertFalse(mode.isOwnerExecutable());
		Assert.assertTrue(mode.isGroupReadable());
		Assert.assertFalse(mode.isGroupWriteable());
		Assert.assertFalse(mode.isGroupExecutable());
		Assert.assertTrue(mode.isOtherReadable());
		Assert.assertFalse(mode.isOtherWriteable());
		Assert.assertFalse(mode.isOtherExecutable());

		mode = new FileModeImpl(06755);
		Assert.assertEquals(06755, mode.getMode());
		Assert.assertEquals("755", mode.getOctal());
		Assert.assertEquals("rwxr-xr-x", mode.getText());
		Assert.assertEquals(6, mode.getStickyBit());
		Assert.assertTrue(mode.isOwnerReadable());
		Assert.assertTrue(mode.isOwnerWriteable());
		Assert.assertTrue(mode.isOwnerExecutable());
		Assert.assertTrue(mode.isGroupReadable());
		Assert.assertFalse(mode.isGroupWriteable());
		Assert.assertTrue(mode.isGroupExecutable());
		Assert.assertTrue(mode.isOtherReadable());
		Assert.assertFalse(mode.isOtherWriteable());
		Assert.assertTrue(mode.isOtherExecutable());
		
		mode = new FileModeImpl(0777777);
		Assert.assertEquals(0777777, mode.getMode());
		Assert.assertEquals("777", mode.getOctal());
		Assert.assertEquals("rwxrwxrwx", mode.getText());
		Assert.assertEquals(7, mode.getStickyBit());
		Assert.assertTrue(mode.isOwnerReadable());
		Assert.assertTrue(mode.isOwnerWriteable());
		Assert.assertTrue(mode.isOwnerExecutable());
		Assert.assertTrue(mode.isGroupReadable());
		Assert.assertTrue(mode.isGroupWriteable());
		Assert.assertTrue(mode.isGroupExecutable());
		Assert.assertTrue(mode.isOtherReadable());
		Assert.assertTrue(mode.isOtherWriteable());
		Assert.assertTrue(mode.isOtherExecutable());
	}


}
