/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.store;

import java.util.Comparator;

/**
 * <p>
 * A {@link Comparator} for {@link DataStoreNode}s residing in the same parent
 * node.
 * </p>
 * <p>
 * Directory nodes (see {@link DataStoreNode#isDirectory()} have a higher
 * priority than file nodes (see {@link DataStoreNode#isFile()}). Nodes are
 * compared by their names.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 23.05.2016 by Gerrit Hohl
 */
public class DataStoreNodeComparator implements Comparator<DataStoreNode> {
	
	
	/**
	 * <p>
	 * Creates a comparator.
	 * </p>
	 */
	public DataStoreNodeComparator() {
		super();
	}
	
	
	@Override
	public int compare(DataStoreNode o1, DataStoreNode o2) {
		if (o1.isDirectory() && o2.isFile())
			return -1;
		else if (o1.isFile() && o2.isDirectory())
			return 1;
		
		return o1.getName().compareTo(o2.getName());
	}


}
