/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.replace;

import net.sourceforge.javadpkg.Warning;


/**
 * <p>
 * A warning for an unknown variable found during a replacement.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 02.05.2016 by Gerrit Hohl
 */
public class ReplacementVariableUnknownWarning implements Warning {


	/** The name of the variable. */
	private String name;


	/**
	 * <p>
	 * Creates a warning.
	 * </p>
	 *
	 * @param name
	 *            The name of the variable.
	 * @throws IllegalArgumentException
	 *             If the name is <code>null</code>.
	 */
	public ReplacementVariableUnknownWarning(String name) {
		super();
		
		if (name == null)
			throw new IllegalArgumentException("Argument name is null.");

		this.name = name;
	}
	
	
	@Override
	public String getText() {
		StringBuilder sb;
		
		
		sb = new StringBuilder();
		sb.append("Found unknown variable |");
		sb.append(this.name);
		sb.append("|. The variable will be ignored and not replaced.");
		
		return sb.toString();
	}

}
