/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.IOException;
import java.io.InputStream;

import net.sourceforge.javadpkg.io.DataProducer;


/**
 * <p>
 * A {@link DataProducer} which reads the data from an {@link InputStream}.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 27.04.2016 by Gerrit Hohl
 */
public class DataStreamProducer implements DataProducer {


	/** The input stream. */
	private InputStream	in;
	/** The name of the producer in the exception (if one is thrown). */
	private String		name;


	/**
	 * <p>
	 * Creates a producer.
	 * </p>
	 *
	 * @param in
	 *            The input stream.
	 * @param name
	 *            The name of the producer in the exception (if one is thrown).
	 * @throws IllegalArgumentException
	 *             If any of the parameters are <code>null</code>.
	 */
	public DataStreamProducer(InputStream in, String name) {
		super();
		
		if (in == null)
			throw new IllegalArgumentException("Argument in is null.");
		if (name == null)
			throw new IllegalArgumentException("Argument name is null.");

		this.in = in;
		this.name = name;
	}


	@Override
	public String getName() {
		return this.name;
	}


	@Override
	public int produce(byte[] buffer) throws IOException {
		int length;


		if (buffer == null)
			throw new IllegalArgumentException("Argument buffer is null.");
			
		try {
			length = this.in.read(buffer);
		} catch (IOException e) {
			throw new IOException("Couldn't read from " + this.name + ": " + e.getMessage(), e);
		}
		return length;
	}


}
