/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2015 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;

/**
 * <p>
 * The target for writing data.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 31.12.2015 by Gerrit Hohl
 */
public interface DataTarget extends Closeable {
	
	
	/**
	 * <p>
	 * Returns the name of the source.
	 * </p>
	 * <p>
	 * This name is used e.g. for detail messages of exceptions.
	 * </p>
	 *
	 * @return The name.
	 */
	String getName();
	
	
	/**
	 * <p>
	 * Returns a stream for writing the data.
	 * </p>
	 * <p>
	 * The method will always return the same {@link OutputStream} if the source
	 * is still open. If the {@link OutputStream#close()} method is called the
	 * source will behave the same as the {@link #close()} method was called.
	 * </p>
	 *
	 * @return The stream.
	 * @throws IOException
	 *             If an I/O error occurs.
	 */
	OutputStream getOutputStream() throws IOException;


}
