/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import net.sourceforge.javadpkg.Warning;


/**
 * <p>
 * A warning for a duplicated template in the templates.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 29.04.2016 by Gerrit Hohl
 */
public class TemplatesDuplicatedTemplateWarning implements Warning {
	
	
	/** The name of the duplicated template. */
	private String name;
	
	
	/**
	 * <p>
	 * Creates a warning.
	 * </p>
	 *
	 * @param name
	 *            The name of the duplicated template.
	 * @throws IllegalArgumentException
	 *             If the warning is <code>null</code>.
	 */
	public TemplatesDuplicatedTemplateWarning(String name) {
		super();
		
		if (name == null)
			throw new IllegalArgumentException("Argument name is null.");

		this.name = name;
	}


	@Override
	public String getText() {
		StringBuilder sb;


		sb = new StringBuilder();
		sb.append("Found template |");
		sb.append(this.name);
		sb.append("| more than once in the templates. Duplicates will be ignored.");

		return sb.toString();
	}
	
	
}
