/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.javadpkg.MD5Sums;


/**
 * <p>
 * A {@link MD5Sums} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 03.01.2016 by Gerrit Hohl
 */
public class MD5SumsImpl implements MD5Sums {
	
	
	/** The entries. */
	private List<Entry> entries;
	
	
	/**
	 * <p>
	 * Creates the MD5 sums.
	 * </p>
	 */
	public MD5SumsImpl() {
		super();
		
		this.entries = new ArrayList<>();
	}
	
	
	/**
	 * <p>
	 * Adds a MD5 sum for a file.
	 * </p>
	 *
	 * @param md5Sum
	 *            The MD5 sum.
	 * @param path
	 *            The path of the file.
	 * @throws IllegalArgumentException
	 *             If any of the parameters are <code>null</code>.
	 */
	public void addMD5Sum(String md5Sum, String path) {
		Entry entry;
		
		
		if (md5Sum == null)
			throw new IllegalArgumentException("Argument md5Sum is null.");
		if (path == null)
			throw new IllegalArgumentException("Argument path is null.");

		entry = new Entry(md5Sum, path);
		this.entries.add(entry);
	}


	@Override
	public String getText() {
		StringBuilder sb;


		sb = new StringBuilder();
		for (Entry entry : this.entries) {
			if (sb.length() > 0)
				sb.append('\n');
			sb.append(entry.getMD5Sum());
			sb.append(' ');
			sb.append(entry.getPath());
		}
		return sb.toString();
	}


	/* **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 */


	/**
	 * <p>
	 * An entry in the MD5 sums.
	 * </p>
	 *
	 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
	 * @version <b>1.0</b>, 03.01.2016 by Gerrit Hohl
	 */
	private class Entry {
		
		
		/** The MD5 sum. */
		private String	md5Sum;
		/** The file path. */
		private String	path;
						
						
		/**
		 * <p>
		 * Creates an entry.
		 * </p>
		 *
		 * @param md5Sum
		 *            The MD5 sum.
		 * @param path
		 *            The file path.
		 */
		public Entry(String md5Sum, String path) {
			super();
			
			this.md5Sum = md5Sum;
			this.path = path;
		}


		/**
		 * <p>
		 * Returns the MD5 sum.
		 * </p>
		 *
		 * @return The MD5 sum.
		 */
		public String getMD5Sum() {
			return this.md5Sum;
		}


		/**
		 * <p>
		 * Returns the path.
		 * </p>
		 *
		 * @return The path.
		 */
		public String getPath() {
			return this.path;
		}


	}


}
