/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import net.sourceforge.javadpkg.CopyrightLicense;


/**
 * <p>
 * A {@link CopyrightLicense} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 06.05.2016 by Gerrit Hohl
 */
public class CopyrightLicenseImpl implements CopyrightLicense {
	
	
	/** The name of the license. */
	private String	name;
	/** The text of the license. */
	private String	text;
	/** The comment. */
	private String	comment;
	
	
	/**
	 * <p>
	 * Creates a license.
	 * </p>
	 */
	public CopyrightLicenseImpl() {
		super();
		
		this.name = null;
		this.text = null;
		this.comment = null;
	}


	@Override
	public String getName() {
		return this.name;
	}
	
	
	/**
	 * <p>
	 * Sets the name of the license.
	 * </p>
	 *
	 * @param name
	 *            The name
	 */
	public void setName(String name) {
		this.name = name;
	}


	@Override
	public String getText() {
		return this.text;
	}
	
	
	/**
	 * <p>
	 * Sets the text of the license.
	 * </p>
	 *
	 * @param text
	 *            The text.
	 */
	public void setText(String text) {
		this.text = text;
	}
	
	
	@Override
	public String getComment() {
		return this.comment;
	}
	
	
	/**
	 * <p>
	 * Sets the comment.
	 * </p>
	 * 
	 * @param comment
	 *            The comment.
	 */
	public void setComment(String comment) {
		this.comment = comment;
	}


}
