/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import net.sourceforge.javadpkg.ConfigFiles;
import net.sourceforge.javadpkg.ConfigFilesParser;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.GlobalConstants;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.io.DataSource;


/**
 * <p>
 * A {@link ConfigFilesParser} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 03.01.2016 by Gerrit Hohl
 */
public class ConfigFilesParserImpl implements ConfigFilesParser, GlobalConstants {


	/**
	 * <p>
	 * Creates a parser.
	 * </p>
	 */
	public ConfigFilesParserImpl() {
		super();
	}


	@Override
	public ConfigFiles parseConfigFiles(DataSource source, Context context) throws IOException, ParseException {
		ConfigFilesImpl configFiles;
		String line;
		
		
		if (source == null)
			throw new IllegalArgumentException("Argument source is null.");
		if (context == null)
			throw new IllegalArgumentException("Argument context is null.");

		configFiles = new ConfigFilesImpl();
		try {
			try (BufferedReader reader = new BufferedReader(new InputStreamReader(source.getInputStream(), UTF_8_CHARSET))) {
				while ((line = reader.readLine()) != null) {
					configFiles.addPath(line);
				}
			}
		} catch (IOException e) {
			throw new IOException(
					"Couldn't read the configuration files from source |" + source.getName() + "|: " + e.getMessage());
		}
		return configFiles;
	}
	
	
}
