/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.javadpkg.ConfigFiles;


/**
 * <p>
 * A {@link ConfigFiles} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 03.01.2016 by Gerrit Hohl
 */
public class ConfigFilesImpl implements ConfigFiles {
	
	
	/** The paths. */
	private List<String> paths;


	/**
	 * <p>
	 * Creates the configuration files.
	 * </p>
	 */
	public ConfigFilesImpl() {
		super();

		this.paths = new ArrayList<>();
	}


	/**
	 * <p>
	 * Adds a path of a configuration file.
	 * </p>
	 *
	 * @param path
	 *            The path.
	 * @throws IllegalArgumentException
	 *             If the path is <code>null</code>.
	 */
	public void addPath(String path) {
		if (path == null)
			throw new IllegalArgumentException("Argument path is null.");
		this.paths.add(path);
	}


	@Override
	public String getText() {
		StringBuilder sb;


		sb = new StringBuilder();
		for (String path : this.paths) {
			if (sb.length() > 0)
				sb.append('\n');
			sb.append(path);
		}
		return sb.toString();
	}


}
