/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import net.sourceforge.javadpkg.ChangeLogVersionEntryDetail;


/**
 * <p>
 * A {@link ChangeLogVersionEntryDetail} implementation.
 * </p>
 * 
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 06.05.2016 by Gerrit Hohl
 */
public class ChangeLogVersionEntryDetailImpl implements ChangeLogVersionEntryDetail {
	
	
	/** The text. */
	private String text;
	
	
	/**
	 * <p>
	 * Creates a detail.
	 * </p>
	 * 
	 * @param text
	 *            The text.
	 * @throws IllegalArgumentException
	 *             If the text is <code>null</code>.
	 */
	public ChangeLogVersionEntryDetailImpl(String text) {
		super();

		if (text == null)
			throw new IllegalArgumentException("Argument text is null.");
		
		this.text = text;
	}
	
	
	@Override
	public String getText() {
		return this.text;
	}
	
	
	/**
	 * <p>
	 * Sets the text.
	 * </p>
	 * 
	 * @param text
	 *            The text.
	 * @throws IllegalArgumentException
	 *             If the text is <code>null</code>.
	 */
	public void setText(String text) {
		if (text == null)
			throw new IllegalArgumentException("Argument text is null.");
		
		this.text = text;
	}
	
	
}
