/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import net.sourceforge.javadpkg.Warning;

/**
 * <p>
 * A warning that the format of the initial line of a version in the change log
 * is unsupported.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 06.05.2016 by Gerrit Hohl
 */
public class ChangeLogInitialLineUnsupportedWarning implements Warning {
	
	
	/** The initial line. */
	private String	initialLine;
	/** The reason. */
	private String	reason;
	
	
	/**
	 * <p>
	 * Creates a warning.
	 * </p>
	 *
	 * @param initialLine
	 *            The initial line.
	 * @param reason
	 *            The reason.
	 * @throws IllegalArgumentException
	 *             If any of the parameters are <code>null</code>.
	 */
	public ChangeLogInitialLineUnsupportedWarning(String initialLine, String reason) {
		super();
		
		if (initialLine == null)
			throw new IllegalArgumentException("Argument initialLine is null.");
		if (reason == null)
			throw new IllegalArgumentException("Argument reason is null.");
		
		this.initialLine = initialLine;
		this.reason = reason;
	}
	
	
	@Override
	public String getText() {
		StringBuilder sb;
		
		
		sb = new StringBuilder();
		sb.append("The format of the initial line |");
		sb.append(this.initialLine);
		sb.append("| of a version in the change log is not supported. The reason: ");
		sb.append(this.reason);
		
		return sb.toString();
	}


}
