/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.field;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.io.DataSource;

/**
 * <p>
 * A parser for fields.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 03.01.2016 by Gerrit Hohl
 */
public interface FieldParser {
	
	
	/**
	 * <p>
	 * Parses fields from the specified source.
	 * </p>
	 * <p>
	 * The key of the returned map is the field name in lower-case.
	 * </p>
	 * <p>
	 * If a field with the same name occurs twice or more a
	 * {@link ParseException} is thrown.
	 * </p>
	 * <p>
	 * Empty fields as well as nameless fields are ignored and never returned.
	 * </p>
	 *
	 * @param source
	 *            The source.
	 * @param context
	 *            The context.
	 * @return The fields as map.
	 * @throws IllegalArgumentException
	 *             If any of the parameters are <code>null</code>.
	 * @throws IOException
	 *             If an I/O error occurs.
	 * @throws ParseException
	 *             If an error occurs during the parsing.
	 */
	Map<String, Field> parseFieldsAsMap(DataSource source, Context context) throws IOException, ParseException;
	
	
	/**
	 * <p>
	 * Parses fields from the specified source.
	 * </p>
	 * <p>
	 * Empty fields are returned based on the configuration of the
	 * {@link FieldParser} implementation.
	 * </p>
	 *
	 * @param source
	 *            The source.
	 * @param context
	 *            The context.
	 * @return The fields as list.
	 * @throws IllegalArgumentException
	 *             If any of the parameters are <code>null</code>.
	 * @throws IOException
	 *             If an I/O error occurs.
	 * @throws ParseException
	 *             If an error occurs during the parsing.
	 */
	List<Field> parseFieldsAsList(DataSource source, Context context) throws IOException, ParseException;
	
	
}
