/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.field;


/**
 * <p>
 * A field having a name and a value.
 * </p>
 * <p>
 * The name and value of empty fields are <code>null</code>. These fields
 * represents empty lines in the source / target.
 * </p>
 * <p>
 * The value can contain newlines.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 03.01.2016 by Gerrit Hohl
 */
public interface Field {
	
	
	/**
	 * <p>
	 * Returns the name.
	 * </p>
	 *
	 * @return The name or <code>null</code>, if the field is an empty field or
	 *         a nameless field.
	 * @see #isEmpty()
	 * @see #isNameless()
	 */
	String getName();
	
	
	/**
	 * <p>
	 * Returns the flag if the field has no name.
	 * </p>
	 * <p>
	 * An nameless field has no name, but a value.
	 * </p>
	 *
	 * @return The flag: <code>true</code>, if the field has no name,
	 *         <code>false</code> otherwise.
	 * @see #getName()
	 */
	boolean isNameless();
	
	
	/**
	 * <p>
	 * Returns the value.
	 * </p>
	 * <p>
	 * The value can contain newlines.
	 * </p>
	 *
	 * @return The value or <code>null</code>, if the field is an empty field.
	 * @see #isEmpty()
	 */
	String getValue();
	
	
	/**
	 * <p>
	 * Returns the value.
	 * </p>
	 * <p>
	 * The value can contain newlines. All &quot;.&quot; lines are replaced by
	 * empty lines.
	 * </p>
	 * 
	 * @return The value or <code>null</code>, if the field is an empty field.
	 * @see #isEmpty()
	 */
	String getFormattedValue();
	
	
	/**
	 * <p>
	 * Returns the flag if the field is an empty field.
	 * </p>
	 * <p>
	 * An empty field has no name and no value.
	 * </p>
	 *
	 * @return The flag: <code>true</code>, if the field is an empty field.
	 * @see #getName()
	 * @see #getValue()
	 */
	boolean isEmpty();
	
	
}
