/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageNameParser;


/**
 * <p>
 * A {@link PackageNameParser} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 01.01.2016 by Gerrit Hohl
 */
public class PackageNameParserImpl implements PackageNameParser {
	
	
	/**
	 * <p>
	 * Creates a parser.
	 * </p>
	 */
	public PackageNameParserImpl() {
		super();
	}
	
	
	@Override
	public PackageName parsePackageName(String value, Context context) throws ParseException {
		PackageName packageName;
		
		
		if (value == null)
			throw new IllegalArgumentException("Argument value is null.");
		if (context == null)
			throw new IllegalArgumentException("Argument context is null.");
		
		// TODO How should be handle names like "python3:any"?
		if (!value.matches("[a-z]{1}[a-z0-9+-.:]+"))
			throw new ParseException("Package name |" + value + "| doesn't match the rules for package names.");
		
		packageName = new PackageNameImpl(value);
		return packageName;
	}


	/* **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 */


	/**
	 * <p>
	 * The {@link PackageName} implementation of this class.
	 * </p>
	 *
	 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
	 * @version <b>1.0</b>, 01.01.2016 by Gerrit Hohl
	 */
	private class PackageNameImpl implements PackageName {
		
		
		/** The name. */
		private String name;


		/**
		 * <p>
		 * Creates a package name.
		 * </p>
		 *
		 * @param name
		 *            The name.
		 */
		public PackageNameImpl(String name) {
			super();

			this.name = name;
		}


		@Override
		public String getName() {
			return this.name;
		}


	}
	
	
}
