/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.control.PackageMaintainer;
import net.sourceforge.javadpkg.control.PackageMaintainerBuilder;


/**
 * <p>
 * A {@link PackageMaintainerBuilder} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 28.04.2016 by Gerrit Hohl
 */
public class PackageMaintainerBuilderImpl implements PackageMaintainerBuilder {


	/**
	 * <p>
	 * Creates a builder.
	 * </p>
	 */
	public PackageMaintainerBuilderImpl() {
		super();
	}
	
	
	@Override
	public String buildPackageMaintainer(PackageMaintainer maintainer, Context context) throws BuildException {
		StringBuilder value;
		
		
		if (maintainer == null)
			throw new IllegalArgumentException("Argument maintainer is null.");
		if (context == null)
			throw new IllegalArgumentException("Argument context is null.");

		value = new StringBuilder();
		value.append(maintainer.getName());
		value.append(" <");
		value.append(maintainer.getAddress());
		value.append('>');
		
		return value.toString();
	}


}
