/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.control.Description;
import net.sourceforge.javadpkg.control.DescriptionBuilder;


/**
 * <p>
 * A {@link DescriptionBuilder} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 28.04.2016 by Gerrit Hohl
 */
public class DescriptionBuilderImpl implements DescriptionBuilder {
	
	
	/**
	 * <p>
	 * Creates a builder.
	 * </p>
	 */
	public DescriptionBuilderImpl() {
		super();
	}
	
	
	@Override
	public String buildDescription(Description description, Context context) throws BuildException {
		String text;
		String[] lines;
		StringBuilder sb;


		if (description == null)
			throw new IllegalArgumentException("Argument description is null.");
		if (context == null)
			throw new IllegalArgumentException("Argument context is null.");

		text = description.getText();
		lines = text.split("\n", -1);
		sb = new StringBuilder();
		for (String line : lines) {
			if (sb.length() > 0) {
				sb.append('\n');
			}
			if (line.isEmpty()) {
				sb.append('.');
			} else {
				sb.append(line);
			}
		}
		return sb.toString();
	}


}
