/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.Warning;


/**
 * <p>
 * A warning about an recommended field which is missing in the control file.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 28.04.2016 by Gerrit Hohl
 */
public class ControlRecommendedFieldMissingWarning implements Warning {


	/** The field name. */
	private String fieldName;
	
	
	/**
	 * <p>
	 * Creates a warning.
	 * </p>
	 *
	 * @param fieldName
	 *            The field name.
	 * @throws IllegalArgumentException
	 *             If the field name is <code>null</code>.
	 */
	public ControlRecommendedFieldMissingWarning(String fieldName) {
		super();

		if (fieldName == null)
			throw new IllegalArgumentException("Argument fieldName is null.");
			
		this.fieldName = fieldName;
	}


	@Override
	public String getText() {
		StringBuilder sb;


		sb = new StringBuilder();
		sb.append("Recommended field |");
		sb.append(this.fieldName);
		sb.append("| is missing in the control file.");

		return sb.toString();
	}


}
