/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;

/**
 * <p>
 * Parses the size.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 03.01.2016 by Gerrit Hohl
 */
public interface SizeParser {
	
	
	/**
	 * <p>
	 * Parses a size in kilobytes.
	 * </p>
	 *
	 * @param value
	 *            The value.
	 * @param context
	 *            The context.
	 * @return The size.
	 * @throws IllegalArgumentException
	 *             If any of the parameters are <code>null</code>.
	 * @throws ParseException
	 *             If an error occurs during the parsing.
	 */
	Size parseSizeInKiloBytes(String value, Context context) throws ParseException;
	
	
}
