/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2015 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control;


/**
 * <p>
 * The size of data.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 31.12.2015 by Gerrit Hohl
 */
public class Size {


	/** The size in bytes. */
	private long size;


	/**
	 * <p>
	 * Creates a size of 0 bytes.
	 * </p>
	 */
	public Size() {
		super();

		this.size = 0;
	}


	/**
	 * <p>
	 * Creates a size in bytes.
	 * </p>
	 *
	 * @param size
	 *            The size in bytes.
	 */
	public Size(long size) {
		super();

		this.size = size;
	}


	/**
	 * <p>
	 * Returns the size in bytes.
	 * </p>
	 *
	 * @return The size.
	 */
	public long getBytes() {
		return this.size;
	}
	
	
	/**
	 * <p>
	 * Returns the size in kilobytes.
	 * </p>
	 * <p>
	 * The size is divided by 1024 and rounded up.
	 * </p>
	 *
	 * @return The size.
	 */
	public long getKiloBytes() {
		long result;
		
		
		result = (this.size / 1024) + ((this.size % 1024) > 0 ? 1 : 0);
		return result;
	}


	/**
	 * <p>
	 * Returns the size for the specified number of bytes.
	 * </p>
	 * 
	 * @param size
	 *            The size in bytes.
	 * @return The size.
	 */
	public static Size getSizeInBytes(long size) {
		Size result;


		result = new Size(size);
		return result;
	}
	
	
	/**
	 * <p>
	 * Returns the size for the specified number of kilobytes.
	 * </p>
	 * 
	 * @param size
	 *            The size in kilobytes.
	 * @return The size.
	 */
	public static Size getSizeInKiloBytes(long size) {
		Size result;


		result = new Size(size * 1024);
		return result;
	}


}
