/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control;

import net.sourceforge.javadpkg.GlobalConstants;

/**
 * <p>
 * The constants of the control.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 28.04.2016 by Gerrit Hohl
 */
public interface ControlConstants extends GlobalConstants {


	/** The name of the field for the package. */
	String	FIELD_PACKAGE				= "Package";
	/** The name of the field for the source. */
	String	FIELD_SOURCE				= "Source";
	/** The name of the field for the version. */
	String	FIELD_VERSION				= "Version";
	/** The name of the field for the section. */
	String	FIELD_SECTION				= "Section";
	/** The name of the field for the priority. */
	String	FIELD_PRIORITY				= "Priority";
	/** The name of the field for the architecture. */
	String	FIELD_ARCHITECTURE			= "Architecture";
	/** The name of the field for the multiple architectures. */
	String	FIELD_MULTI_ARCH			= "Multi-Arch";
	/** The name of the field for the essential flag. */
	String	FIELD_ESSENTIAL				= "Essential";
	/** The name of the field for the dependencies. */
	String	FIELD_DEPENDS				= "Depends";
	/** The name of the field for the recommended dependencies. */
	String	FIELD_RECOMMENDS			= "Recommends";
	/** The name of the field for the suggested dependencies. */
	String	FIELD_SUGGESTS				= "Suggests";
	/** The name of the field for the enhancement dependencies. */
	String	FIELD_ENHANCES				= "Enhance";
	/** The name of the field for the pre-dependencies. */
	String	FIELD_PRE_DEPENDS			= "Pre-Depends";
	/** The name of the field for the break dependencies. */
	String	FIELD_BREAKS				= "breaks";
	/** The name of the field for the conflict dependencies. */
	String	FIELD_CONFLICTS				= "Conflicts";
	/** The name of the field for the provided package (virtual package). */
	String	FIELD_PROVIDES				= "Provides";
	/** The name of the field for the replace package. */
	String	FIELD_REPLACES				= "Replaces";
	/** The name of the field for the built-using dependencies. */
	String	FIELD_BUILT_USING			= "Built-Using";
	/** The name of the field for the installed size. */
	String	FIELD_INSTALLED_SIZE		= "Installed-Size";
	/** The name of the field for the maintainer. */
	String	FIELD_MAINTAINER			= "Maintainer";
	/** The name of the field for the original maintainer. */
	String	FIELD_ORIGINAL_MAINTAINER	= "Original-Maintainer";
	/** The name of the field for the module aliases. */
	String	FIELD_MODALIASES			= "Modaliases";
	/** The name of the field for the description. */
	String	FIELD_DESCRIPTION			= "Description";
	/** The name of the field for the home-page. */
	String	FIELD_HOMEPAGE				= "Homepage";
	/** The name of the field for the tag. */
	String	FIELD_TAG					= "Tag";
	/** The name of the field for the origin. */
	String	FIELD_ORIGIN				= "Origin";
	/** The name of the field for the bugs. */
	String	FIELD_BUGS					= "Bugs";
	/** The name of the field for the Python version. */
	String	FIELD_PYTHON_VERSION		= "Python-Version";
	/** The name of the field for the original maintainer. */
	String	FIELD_ORIG_MAINTAINER		= "Orig-Maintainer";
										
										
}
