/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg;

import java.util.List;
import java.util.Map;

import net.sourceforge.javadpkg.control.Description;

/**
 * <p>
 * A template.
 * </p>
 *
 * @see Templates
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 29.04.2016 by Gerrit Hohl
 */
public interface Template {


	/**
	 * <p>
	 * Returns the name of the template.
	 * </p>
	 *
	 * @return The name.
	 */
	String getName();


	/**
	 * <p>
	 * Returns the type.
	 * </p>
	 *
	 * @return The type.
	 */
	TemplateType getType();


	/**
	 * <p>
	 * Returns the default values.
	 * </p>
	 *
	 * @return The default values or <code>null</code>, if no default values are
	 *         specified.
	 */
	Map<String, String> getDefaultValue();
	
	
	/**
	 * <p>
	 * Returns the choices.
	 * </p>
	 *
	 * @return The choices or <code>null</code>, if no choices are specified.
	 */
	Map<String, List<String>> getChoices();


	/**
	 * <p>
	 * Returns the descriptions.
	 * </p>
	 *
	 * @return The descriptions.
	 */
	Map<String, Description> getDescriptions();
	
	
}
