/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg;

import java.io.IOException;

import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.store.DataStore;

/**
 * <p>
 * A builder for creating the MD5 sums.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 26.04.2016 by Gerrit Hohl
 * @version <b>1.1</b>, 23.01.2018 by Gerrit Hohl
 */
public interface MD5SumsBuilder {


	/**
	 * <p>
	 * Builds the MD5 sums and stores them in the target.
	 * </p>
	 *
	 * @param store
	 *            The store containing the file for which the MD5 sums should be
	 *            created.
	 * @param target
	 *            The target.
	 * @throws IllegalArgumentException
	 *             If any of the parameters are <code>null</code>.
	 * @throws IOException
	 *             If an I/O error occurs.
	 * @throws BuildException
	 *             If an error occurs during the building.
	 */
	void buildMD5Sums(DataStore store, DataTarget target) throws IOException, BuildException;
	
	
}
