/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg;

import java.util.List;

/**
 * <p>
 * A context for various actions like parsing or building.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 23.04.2016 by Gerrit Hohl
 */
public interface Context {
	
	
	/**
	 * <p>
	 * Adds a warning to the context.
	 * </p>
	 * <p>
	 * Warnings can inform about unsupported parameters, unsupported values or
	 * combinations of these. The action will resume it's work (best-effort). If
	 * the problems prevents the rest of the action from working correctly an
	 * exception should be thrown.
	 * </p>
	 *
	 * @param warning
	 *            The warning.
	 * @throws IllegalArgumentException
	 *             If the warning is <code>null</code>.
	 */
	void addWarning(Warning warning);


	/**
	 * <p>
	 * Returns a list of all warnings added to this context.
	 * </p>
	 * <p>
	 * The returned list will be a copy of the internal list. Modifications on
	 * the returned list don't have any effect on the internal list.
	 * </p>
	 * 
	 * @return The warnings.
	 */
	List<Warning> getWarnings();


}
