/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg;


/**
 * <p>
 * Thrown if an error occurs while building.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 28.04.2016 by Gerrit Hohl
 */
public class BuildException extends Exception {


	/** The version of this class. */
	private static final long serialVersionUID = -8892907781639900345L;
	
	
	/**
	 * <p>
	 * Constructs a new exception with the specified detail message.
	 * </p>
	 *
	 * @param message
	 *            The detail message.
	 */
	public BuildException(String message) {
		super(message);
	}
	
	
	/**
	 * <p>
	 * Constructs a new exception with the specified detail message and cause.
	 * </p>
	 *
	 * @param message
	 *            The detail message.
	 * @param cause
	 *            The cause.
	 */
	public BuildException(String message, Throwable cause) {
		super(message, cause);
	}
	
	
}
