/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.javadpkg.plugin.reflect.PropertyReflection;
import net.sourceforge.javadpkg.plugin.reflect.PropertyReflectionException;

public class PropertyReflectionImpl
implements PropertyReflection {
    @Override
    public Object getValue(Object obj, String path) throws PropertyReflectionException {
        Object value;
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        ArrayList<String> pathElements = new ArrayList<String>(Arrays.asList(path.split("\\.")));
        try {
            value = this.getValue(obj, (String)pathElements.remove(0), pathElements);
        }
        catch (PropertyReflectionException e) {
            throw new PropertyReflectionException("Couldn't return property described by the property path |" + path + "| of the object |" + obj + "| (Class: " + obj.getClass().getCanonicalName() + "|): " + e.getMessage(), e);
        }
        return value;
    }

    private Object getValue(Object obj, String propertyName, List<String> pathElements) throws PropertyReflectionException {
        Object value;
        if (propertyName.isEmpty()) {
            throw new PropertyReflectionException("The path contains an empty element.");
        }
        Class<?> clazz = obj.getClass();
        try {
            Field field = clazz.getField(propertyName);
            value = field.get(obj);
        }
        catch (IllegalAccessException | NoSuchFieldException fe) {
            String getterName = this.buildGetterName(propertyName);
            try {
                Method method = clazz.getMethod(getterName, new Class[0]);
                if (Void.class.equals(method.getReturnType())) {
                    throw new PropertyReflectionException("The getter method |" + getterName + "| of the object |" + obj + "| (Class: " + obj.getClass().getCanonicalName() + "|) has no return type.");
                }
                value = method.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException me) {
                throw new PropertyReflectionException("The property |" + propertyName + "| of the object |" + obj + "| (Class: " + obj.getClass().getCanonicalName() + "|) couldn't be accessed as field as well as using a getter method.", me);
            }
        }
        if (value != null && !pathElements.isEmpty()) {
            value = this.getValue(value, pathElements.remove(0), pathElements);
        }
        return value;
    }

    private String buildGetterName(String propertyName) {
        StringBuilder sb = new StringBuilder();
        sb.append("get");
        sb.append(Character.toUpperCase(propertyName.charAt(0)));
        if (propertyName.length() > 1) {
            sb.append(propertyName.substring(1));
        }
        return sb.toString();
    }
}

