/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.io.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.javadpkg.plugin.io.Path;

public class PathImpl
implements Path {
    private List<String> elements;

    public PathImpl() {
        this.elements = new ArrayList<String>();
    }

    private PathImpl(List<String> elements) {
        this.elements = new ArrayList<String>(elements);
    }

    @Override
    public Path getParentPath() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return new PathImpl(this.elements.subList(0, this.elements.size() - 1));
    }

    @Override
    public Path getChildPath() {
        if (this.elements.size() <= 1) {
            return null;
        }
        return new PathImpl(this.elements.subList(1, this.elements.size()));
    }

    @Override
    public Path createChild(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        ArrayList<String> newElements = new ArrayList<String>(this.elements.size() + 1);
        newElements.addAll(this.elements);
        newElements.add(name);
        PathImpl newPath = new PathImpl(newElements);
        return newPath;
    }

    @Override
    public String getFirstElement() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.get(0);
    }

    @Override
    public String getLastElement() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.get(this.elements.size() - 1);
    }

    @Override
    public String getAbsolutePath() {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        for (String element : this.elements) {
            if (sb.length() > 1) {
                sb.append("/");
            }
            sb.append(element);
        }
        return sb.toString();
    }

    public static Path parsePath(String path) {
        PathImpl result;
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (path.isEmpty() || "/".equals(path)) {
            result = new PathImpl();
        } else {
            String value = path;
            if (value.startsWith("/")) {
                value = value.substring(1);
            }
            if (value.endsWith("/")) {
                value = value.substring(0, value.length() - 1);
            }
            String[] parts = value.split("/", -1);
            result = new PathImpl(Arrays.asList(parts));
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getAbsolutePath().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Path) {
            Path path = (Path)obj;
            equal = this.getAbsolutePath().equals(path.getAbsolutePath());
        }
        return equal;
    }
}

