/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.io.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.javadpkg.DebianPackageConstants;
import net.sourceforge.javadpkg.io.FileMode;
import net.sourceforge.javadpkg.io.FileOwner;
import net.sourceforge.javadpkg.io.impl.FileModeImpl;
import net.sourceforge.javadpkg.io.impl.FileOwnerImpl;
import net.sourceforge.javadpkg.plugin.io.FileSystemNode;
import net.sourceforge.javadpkg.plugin.io.FileSystemNodeComparator;
import net.sourceforge.javadpkg.plugin.io.FileSystemNodeVisitResult;
import net.sourceforge.javadpkg.plugin.io.FileSystemNodeVisitor;
import net.sourceforge.javadpkg.plugin.io.Path;
import net.sourceforge.javadpkg.plugin.io.impl.PathImpl;

public class FileSystemNodeImpl<A>
implements FileSystemNode<A>,
DebianPackageConstants {
    private static final FileOwnerImpl DEFAULT_OWNER = new FileOwnerImpl(0L, "root", 0L, "root");
    private static final FileModeImpl DEFAULT_DIRECTORY_MODE = new FileModeImpl(493);
    private FileSystemNode<A> parent;
    private String name;
    private Path symLinkTarget;
    private FileOwner owner;
    private FileMode mode;
    private A attachment;
    private Map<String, FileSystemNode<A>> children;
    private boolean createdByDependency;

    private FileSystemNodeImpl(String name, Path symLinkTarget, FileOwner owner, FileMode mode, boolean directory, A attachment, boolean createdByDependency) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        this.parent = null;
        this.name = name;
        this.symLinkTarget = symLinkTarget;
        this.owner = owner;
        this.mode = mode;
        this.children = directory ? new HashMap<String, FileSystemNode<A>>() : null;
        this.attachment = attachment;
        this.createdByDependency = createdByDependency;
    }

    public FileSystemNodeImpl(String name) {
        this(name, null, (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_DIRECTORY_MODE, true, null, true);
    }

    @Override
    public FileSystemNode<A> getParent() {
        return this.parent;
    }

    @Override
    public FileSystemNode<A> setParent(FileSystemNode<A> parent) {
        if (this.parent == parent) {
            return this.parent;
        }
        FileSystemNode<A> previousParent = this.parent;
        this.parent = null;
        if (previousParent != null) {
            previousParent.removeChild(this);
        }
        if (parent != null) {
            this.parent = parent;
            this.parent.addChild(this);
        }
        return previousParent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Path getPath() {
        Path path;
        if (this.parent == null) {
            path = new PathImpl();
        } else {
            Path parentPath = this.parent.getPath();
            path = parentPath.createChild(this.name);
        }
        return path;
    }

    @Override
    public Path getSymLinkTarget() {
        return this.symLinkTarget;
    }

    @Override
    public FileOwner getOwner() {
        return this.owner;
    }

    @Override
    public FileMode getMode() {
        return this.mode;
    }

    @Override
    public boolean isDirectory() {
        return this.children != null;
    }

    @Override
    public boolean isFile() {
        return this.children == null;
    }

    @Override
    public boolean isSymLink() {
        return this.symLinkTarget != null;
    }

    @Override
    public A getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAttachment(A attachment) {
        this.attachment = attachment;
    }

    @Override
    public FileSystemNode<A> createChildDirectory(String name, FileOwner owner, FileMode mode, A attachment) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        if (!this.isDirectory()) {
            throw new IllegalStateException("Can't create directory child node |" + name + "| because node |" + this.getPath().getAbsolutePath() + "| is not a directory.");
        }
        if (this.getChild(name) != null) {
            throw new IllegalStateException("Can't create directory child node |" + name + "|: A child node with that name already exists in the directory node |" + this.getPath().getAbsolutePath() + "|.");
        }
        FileSystemNodeImpl<A> childNode = new FileSystemNodeImpl<A>(name, null, owner, mode, true, attachment, false);
        this.addChild(childNode);
        return childNode;
    }

    @Override
    public FileSystemNode<A> createChildFile(String name, FileOwner owner, FileMode mode, A attachment) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        if (!this.isDirectory()) {
            throw new IllegalStateException("Can't create file child node |" + name + "| because node |" + this.getPath().getAbsolutePath() + "| is not a directory.");
        }
        if (this.getChild(name) != null) {
            throw new IllegalStateException("Can't create file child node |" + name + "|: A child node with that name already exists in the directory node |" + this.getPath().getAbsolutePath() + "|.");
        }
        FileSystemNodeImpl<A> childNode = new FileSystemNodeImpl<A>(name, null, owner, mode, false, attachment, false);
        this.addChild(childNode);
        return childNode;
    }

    @Override
    public FileSystemNode<A> createChildSymLink(String name, Path target, FileOwner owner, FileMode mode, A attachment) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        if (!this.isDirectory()) {
            throw new IllegalStateException("Can't create file child node |" + name + "| because node |" + this.getPath().getAbsolutePath() + "| is not a directory.");
        }
        if (this.getChild(name) != null) {
            throw new IllegalStateException("Can't create file child node |" + name + "|: A child node with that name already exists in the directory node |" + this.getPath().getAbsolutePath() + "|.");
        }
        FileSystemNodeImpl<A> childNode = new FileSystemNodeImpl<A>(name, target, owner, mode, false, attachment, false);
        this.addChild(childNode);
        return childNode;
    }

    @Override
    public FileSystemNode<A> addChild(FileSystemNode<A> child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument child is null.");
        }
        if (this.children == null) {
            throw new IllegalStateException("Can't add child |" + child.getName() + "| to path |" + this.getPath().getAbsolutePath() + "| because it is not a directory.");
        }
        FileSystemNode<A> previousChild = this.children.put(child.getName(), child);
        if (previousChild == child) {
            previousChild = null;
        }
        if (child.getParent() != this) {
            child.setParent(this);
        }
        return previousChild;
    }

    @Override
    public FileSystemNode<A> getChild(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (this.children == null) {
            throw new IllegalStateException("Can't search for child |" + name + "| in path |" + this.getPath().getAbsolutePath() + "| because it is not a directory.");
        }
        return this.children.get(name);
    }

    @Override
    public FileSystemNode<A> removeChild(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (this.children == null) {
            throw new IllegalStateException("Can't remove child |" + name + "| in path |" + this.getPath().getAbsolutePath() + "| because it is not a directory.");
        }
        FileSystemNode child = this.children.remove(name);
        if (child != null) {
            child.setParent(null);
        }
        return child;
    }

    @Override
    public boolean removeChild(FileSystemNode<A> child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument child is null.");
        }
        if (this.children == null) {
            throw new IllegalStateException("Can't remove child |" + child.getName() + "| in path |" + this.getPath().getAbsolutePath() + "| because it is not a directory.");
        }
        FileSystemNode<A> node = this.children.get(child.getName());
        if (node == child) {
            this.children.remove(child.getName());
            return true;
        }
        return false;
    }

    @Override
    public List<FileSystemNode<A>> moveChildrenTo(FileSystemNode<A> node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument node is null.");
        }
        if (this.children == null) {
            throw new IllegalStateException("Can't move children from path |" + this.getPath().getAbsolutePath() + "| to path |" + node.getPath().getAbsolutePath() + "| because the source path is not a directory.");
        }
        if (!node.isDirectory()) {
            throw new IllegalStateException("Can't move children from path |" + this.getPath().getAbsolutePath() + "| to path |" + node.getPath().getAbsolutePath() + "| because the target path is not a directory.");
        }
        ArrayList<FileSystemNode<A>> children = new ArrayList<FileSystemNode<A>>(this.children.values());
        ArrayList<FileSystemNode<A>> replacedChildren = new ArrayList<FileSystemNode<A>>();
        for (FileSystemNode fileSystemNode : children) {
            this.removeChild(fileSystemNode);
            FileSystemNode<A> replacedChild = node.addChild(fileSystemNode);
            if (replacedChild == null) continue;
            replacedChildren.add(replacedChild);
        }
        return replacedChildren;
    }

    @Override
    public FileSystemNode<A> createDirectories(Path path) {
        Path childPath;
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (!this.isDirectory()) {
            throw new IllegalStateException("Can't create directories for path |" + path.getAbsolutePath() + "| because this node |" + this.getPath().getAbsolutePath() + "| is not a directory.");
        }
        String name = path.getFirstElement();
        if (name == null) {
            return this;
        }
        FileSystemNode<A> childNode = this.children.get(name);
        if (childNode == null) {
            childNode = new FileSystemNodeImpl<A>(name);
            this.addChild(childNode);
        }
        if ((childPath = path.getChildPath()) != null) {
            childNode = childNode.createDirectories(childPath);
        }
        return childNode;
    }

    @Override
    public FileSystemNode<A> getNode(Path path) {
        Path childPath;
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        String name = path.getFirstElement();
        if (name == null) {
            return this;
        }
        if (!this.isDirectory()) {
            throw new IllegalStateException("Can't return node for path |" + path.getAbsolutePath() + "| because this node |" + this.getPath().getAbsolutePath() + "| is not a directory.");
        }
        FileSystemNode<A> childNode = this.children.get(name);
        if (childNode != null && (childPath = path.getChildPath()) != null) {
            childNode = childNode.getNode(childPath);
        }
        return childNode;
    }

    @Override
    public boolean containsOnlyCreatedByDependency() {
        if (this.children == null) {
            return false;
        }
        for (FileSystemNode<A> child : this.children.values()) {
            if (!child.isCreatedByDependency()) {
                return false;
            }
            if (child.containsOnlyCreatedByDependency()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCreatedByDependency() {
        return this.createdByDependency;
    }

    @Override
    public FileSystemNodeVisitResult walkNodeTree(FileSystemNodeVisitor<A> visitor) throws IOException {
        FileSystemNodeVisitResult result;
        if (visitor == null) {
            throw new IllegalArgumentException("Argument visitor is null.");
        }
        if (this.isDirectory()) {
            result = visitor.preVisitDirectory(this);
            switch (result) {
                case CONTINUE: {
                    result = this.walkChildNodeTree(visitor);
                    if (result != FileSystemNodeVisitResult.TERMINATE) break;
                    return result;
                }
                case SKIP_SIBLINGS: 
                case SKIP_SUBTREE: {
                    break;
                }
                case TERMINATE: {
                    return result;
                }
            }
            result = visitor.postVisitDirectory(this);
        } else {
            result = visitor.visitFile(this);
        }
        return result;
    }

    private FileSystemNodeVisitResult walkChildNodeTree(FileSystemNodeVisitor<A> visitor) throws IOException {
        ArrayList<FileSystemNode<A>> nodes = new ArrayList<FileSystemNode<A>>(this.children.values());
        Collections.sort(nodes, new FileSystemNodeComparator());
        for (FileSystemNode fileSystemNode : nodes) {
            FileSystemNodeVisitResult result = fileSystemNode.walkNodeTree(visitor);
            switch (result) {
                case CONTINUE: {
                    break;
                }
                case SKIP_SIBLINGS: 
                case TERMINATE: {
                    return result;
                }
                case SKIP_SUBTREE: {
                    break;
                }
            }
        }
        return FileSystemNodeVisitResult.CONTINUE;
    }
}

