/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.File;
import net.sourceforge.javadpkg.control.Architecture;
import net.sourceforge.javadpkg.control.BinaryControl;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageVersion;
import net.sourceforge.javadpkg.plugin.TargetFileBuilder;

public class TargetFileBuilderImpl
implements TargetFileBuilder {
    @Override
    public File createTargetFile(File targetDirectory, BinaryControl control) {
        if (targetDirectory == null) {
            throw new IllegalArgumentException("Argument targetDirectory is null.");
        }
        if (control == null) {
            throw new IllegalArgumentException("Argument control is null.");
        }
        File targetFile = this.createTargetFile(targetDirectory, control.getPackage(), control.getVersion(), control.getArchitecture());
        return targetFile;
    }

    @Override
    public File createTargetFile(File targetDirectory, PackageName name, PackageVersion version, Architecture architecture) {
        if (targetDirectory == null) {
            throw new IllegalArgumentException("Argument targetDirectory is null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument version is null.");
        }
        if (architecture == null) {
            throw new IllegalArgumentException("Argument architecture is null.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name.getName());
        sb.append('_');
        sb.append(version.getUpstreamVersion());
        if (version.getDebianRevision() != null) {
            sb.append('-');
            sb.append(version.getDebianRevision());
        }
        sb.append('_');
        sb.append(architecture.getText());
        sb.append(".deb");
        File targetFile = new File(targetDirectory, sb.toString());
        return targetFile;
    }
}

