/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.DataSwap;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.impl.DataFileSource;
import net.sourceforge.javadpkg.io.impl.DataTempFileSwap;
import net.sourceforge.javadpkg.replace.ReplacementException;
import net.sourceforge.javadpkg.replace.Replacements;
import net.sourceforge.javadpkg.replace.Replacer;
import net.sourceforge.javadpkg.replace.ReplacerImpl;

public class DataReplacementSource
implements DataSource {
    private File file;
    private Charset encoding;
    private Replacements replacements;
    private Context context;
    private String name;
    private DataSwap swap;
    private boolean closed;
    private Replacer replacer;

    public DataReplacementSource(File file, Charset encoding, Replacements replacements, Context context) {
        if (file == null) {
            throw new IllegalArgumentException("Argument file is null.");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("Argument encoding is null.");
        }
        if (replacements == null) {
            throw new IllegalArgumentException("Argument replacements is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        this.file = file;
        this.encoding = encoding;
        this.replacements = replacements;
        this.context = context;
        this.name = file.getAbsolutePath();
        this.swap = null;
        this.closed = false;
        this.replacer = new ReplacerImpl();
    }

    public String getName() {
        return this.name;
    }

    public long getLength() {
        long length = -1L;
        try {
            if (this.swap == null) {
                this.replace();
            }
            length = this.swap.getSource().getLength();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return length;
    }

    public boolean isResettable() {
        if (this.swap != null) {
            try {
                return this.swap.getSource().isResettable();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void reset() throws IOException {
        if (this.swap == null) {
            throw new IOException("Source |" + this.name + "| doesn't support a reset.");
        }
        this.swap.getSource().reset();
    }

    public InputStream getInputStream() throws IOException {
        if (this.closed) {
            throw new IOException("The source |" + this.name + "| was already closed.");
        }
        if (this.swap == null) {
            this.replace();
        }
        return this.swap.getSource().getInputStream();
    }

    public void close() throws IOException {
        try {
            if (this.swap != null) {
                this.swap.close();
            }
        }
        finally {
            this.swap = null;
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replace() throws IOException {
        this.swap = new DataTempFileSwap(this.file.getName() + "-swap");
        try (DataFileSource source = new DataFileSource(this.file);
             BufferedReader reader = new BufferedReader(new InputStreamReader(source.getInputStream(), this.encoding));
             DataTarget target = this.swap.getTarget();
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(target.getOutputStream(), this.encoding));){
            String line;
            while ((line = reader.readLine()) != null) {
                line = this.replacer.replace(line, this.replacements, this.context);
                writer.write(line);
                writer.write("\n");
            }
        }
        catch (IOException | ReplacementException e) {
            try {
                this.swap.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.swap = null;
            }
            throw new IOException("Couldn't replace content of file |" + this.file.getAbsolutePath() + "|: " + e.getMessage(), e);
        }
    }
}

