/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.IOException;
import java.nio.charset.Charset;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.DebianPackageBuilder;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.FileOwner;
import net.sourceforge.javadpkg.io.impl.DataFileSource;
import net.sourceforge.javadpkg.plugin.impl.DataReplacementSource;
import net.sourceforge.javadpkg.plugin.impl.FileInfo;
import net.sourceforge.javadpkg.plugin.impl.FileSystemNodeInfo;
import net.sourceforge.javadpkg.plugin.io.FileSystemNode;
import net.sourceforge.javadpkg.plugin.io.FileSystemNodeVisitResult;
import net.sourceforge.javadpkg.plugin.io.FileSystemNodeVisitor;
import net.sourceforge.javadpkg.replace.Replacements;
import org.apache.maven.plugin.logging.Log;

public class DataFileSystemNodeVisitor
implements FileSystemNodeVisitor<FileSystemNodeInfo> {
    private Log log;
    private DebianPackageBuilder builder;
    private Charset defaultEncoding;
    private Replacements replacements;
    private Context context;
    private long size;
    private long files;
    private long directories;
    private long symbolicLinks;
    private boolean process;

    public DataFileSystemNodeVisitor(Log log, DebianPackageBuilder builder, Charset defaultEncoding, Replacements replacements, Context context) {
        if (log == null) {
            throw new IllegalArgumentException("Argument log is null.");
        }
        if (builder == null) {
            throw new IllegalArgumentException("Argument builder is null.");
        }
        if (defaultEncoding == null) {
            throw new IllegalArgumentException("Argument defaultEncoding is null.");
        }
        if (replacements == null) {
            throw new IllegalArgumentException("Argument replacements is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        this.log = log;
        this.builder = builder;
        this.defaultEncoding = defaultEncoding;
        this.replacements = replacements;
        this.context = context;
        this.size = 0L;
        this.files = 0L;
        this.directories = 0L;
        this.symbolicLinks = 0L;
        this.process = false;
    }

    public long getSize() {
        return this.size;
    }

    public long getFiles() {
        return this.files;
    }

    public long getDirectories() {
        return this.directories;
    }

    public long getSymbolicLinks() {
        return this.symbolicLinks;
    }

    public boolean isProcess() {
        return this.process;
    }

    @Override
    public FileSystemNodeVisitResult preVisitDirectory(FileSystemNode<FileSystemNodeInfo> node) throws IOException {
        FileSystemNodeVisitResult result;
        if (node == null) {
            throw new IllegalArgumentException("Argument node is null.");
        }
        if (node.isCreatedByDependency() && node.containsOnlyCreatedByDependency()) {
            result = FileSystemNodeVisitResult.SKIP_SUBTREE;
            FileSystemNode<FileSystemNodeInfo> parent = node.getParent();
            if (parent != null) {
                parent.removeChild(node);
            }
        } else {
            this.log(node);
            ++this.directories;
            if (node.getParent() != null) {
                this.builder.addDataDirectory(node.getPath().getAbsolutePath(), node.getOwner(), node.getMode());
            }
            result = FileSystemNodeVisitResult.CONTINUE;
        }
        return result;
    }

    @Override
    public FileSystemNodeVisitResult visitFile(FileSystemNode<FileSystemNodeInfo> node) throws IOException {
        if (node == null) {
            throw new IllegalArgumentException("Argument node is null.");
        }
        this.log(node);
        if (node.isSymLink()) {
            this.builder.addDataSymLink(node.getPath().getAbsolutePath(), node.getSymLinkTarget().getAbsolutePath(), node.getOwner(), node.getMode());
            ++this.symbolicLinks;
        } else {
            Object source;
            FileSystemNodeInfo info = node.getAttachment();
            if (info == null) {
                throw new IOException("Node |" + node.getPath().getAbsolutePath() + "| doesn't have a file as attachment.");
            }
            FileInfo fileInfo = info.getSource();
            if (!fileInfo.exists()) {
                throw new IOException("The file |" + fileInfo.getAbsolutePath() + "| of node |" + node.getPath().getAbsolutePath() + "| doesn't exist.");
            }
            if (!fileInfo.isFile()) {
                throw new IOException("The file |" + fileInfo.getAbsolutePath() + "| of node |" + node.getPath().getAbsolutePath() + "| is not a regular file.");
            }
            this.size += fileInfo.getLength();
            ++this.files;
            if (info.isProcess()) {
                Charset encoding;
                if (info.getEncoding() == null) {
                    encoding = this.defaultEncoding;
                } else {
                    try {
                        encoding = Charset.forName(info.getEncoding());
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException("Encoding |" + info.getEncoding() + "| for source file |" + fileInfo.getAbsolutePath() + "| is not supported by this JVM: " + e.getMessage());
                    }
                }
                source = new DataReplacementSource(fileInfo.getFile(), encoding, this.replacements, this.context);
                this.process = true;
            } else {
                source = new DataFileSource(fileInfo.getFile());
            }
            this.builder.addDataFile((DataSource)source, node.getPath().getAbsolutePath(), node.getOwner(), node.getMode());
        }
        return FileSystemNodeVisitResult.CONTINUE;
    }

    @Override
    public FileSystemNodeVisitResult postVisitDirectory(FileSystemNode<FileSystemNodeInfo> node) throws IOException {
        if (node == null) {
            throw new IllegalArgumentException("Argument node is null.");
        }
        return FileSystemNodeVisitResult.CONTINUE;
    }

    private void log(FileSystemNode<FileSystemNodeInfo> node) {
        if (this.log.isInfoEnabled()) {
            FileOwner owner = node.getOwner();
            Long groupId = owner.getGroupId();
            Long userId = owner.getUserId();
            Long size = 0L;
            String source = null;
            String target = null;
            StringBuilder sb = new StringBuilder();
            if (node.isDirectory()) {
                sb.append('d');
            } else {
                FileSystemNodeInfo info = node.getAttachment();
                if (info != null) {
                    size = info.getSource().getLength();
                    source = info.getSource().getAbsolutePath();
                }
                if (node.isSymLink()) {
                    target = node.getSymLinkTarget().getAbsolutePath();
                    sb.append('l');
                } else {
                    sb.append('-');
                }
            }
            sb.append(node.getMode().getText());
            sb.append(String.format(" %5d %-8s %5d %-8s %10d %-40s", groupId, owner.getGroupName(), userId, owner.getUserName(), size, node.getPath().getAbsolutePath()));
            if (source != null) {
                sb.append(String.format(" (Source: |%s|)", source));
            } else if (target != null) {
                sb.append(String.format(" (Target: |%s|)", target));
            }
            this.log.info((CharSequence)sb.toString());
        }
    }
}

