/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.plugin.cfg.DataEntry;
import net.sourceforge.javadpkg.plugin.impl.DataEntryNode;
import net.sourceforge.javadpkg.plugin.io.Path;
import net.sourceforge.javadpkg.plugin.io.impl.PathImpl;
import net.sourceforge.javadpkg.plugin.io.impl.WildcardFileFilter;
import org.apache.maven.plugin.logging.Log;

public class DataEntryNodeTransformer {
    public List<DataEntryNode> transform(Log log, List<DataEntry> entries) throws IOException, ParseException {
        if (log == null) {
            throw new IllegalArgumentException("Argument log is null.");
        }
        if (entries == null) {
            throw new IllegalArgumentException("Argument entries is null.");
        }
        ArrayList<DataEntryNode> nodes = new ArrayList<DataEntryNode>();
        for (DataEntry entry : entries) {
            DataEntryNode node;
            Path parentPath;
            String targetName;
            this.logDataEntry(log, entry);
            String target = entry.getTargetPath();
            if (this.isEmpty(target)) {
                throw new ParseException("Couldn't add target path: Target not set.");
            }
            Path path = PathImpl.parsePath(target);
            String symLink = entry.getSymLinkPath();
            String source = entry.getSourcePath();
            if (!this.isEmpty(source)) {
                ArrayList<FileEntry> fileEntries;
                if (!this.isEmpty(symLink)) {
                    throw new ParseException("Couldn't process source path |" + source + "|: A symbolic link |" + symLink + "| is also set in the entry.");
                }
                File sourceFile = new File(source);
                String sourceName = sourceFile.getName();
                if (sourceName.contains("*") || sourceName.contains("?")) {
                    File parentFile = sourceFile.getParentFile();
                    if (!parentFile.exists()) {
                        throw new IOException("Couldn't process source path |" + source + "|: The directory |" + parentFile.getAbsolutePath() + "| does not exist.");
                    }
                    if (!parentFile.isDirectory()) {
                        throw new IOException("Couldn't process source path |" + source + "|:The path |" + parentFile.getAbsolutePath() + "| is not a directory.");
                    }
                    fileEntries = this.walkTree(parentFile, sourceName, path, "", entry.isRecursive());
                } else {
                    fileEntries = new ArrayList();
                    if (sourceFile.isDirectory() && entry.isRecursive()) {
                        targetName = path.getLastElement();
                        parentPath = path.getParentPath();
                        fileEntries.add(new FileEntry(targetName, parentPath, ""));
                        fileEntries.addAll(this.walkTree(sourceFile, null, path, targetName, entry.isRecursive()));
                    } else {
                        if (sourceFile.isDirectory()) {
                            throw new IOException("Couldn't process source path |" + source + "|: The path |" + sourceFile.getAbsolutePath() + "| is a directory and recursion is not enabled.");
                        }
                        if (target.endsWith("/")) {
                            targetName = sourceName;
                            parentPath = path;
                        } else {
                            targetName = path.getLastElement();
                            parentPath = path.getParentPath();
                        }
                        fileEntries.add(new FileEntry(sourceFile, targetName, parentPath, ""));
                    }
                }
                this.logFileEntries(log, fileEntries, source);
                for (FileEntry fileEntry : fileEntries) {
                    node = fileEntry.isDirectory() ? new DataEntryNode(fileEntry.getName(), fileEntry.getParent(), entry.getGroupId(), entry.getGroupName(), entry.getUserId(), entry.getUserName(), entry.getMode()) : new DataEntryNode(fileEntry.getSource(), fileEntry.getName(), fileEntry.getParent(), entry.getGroupId(), entry.getGroupName(), entry.getUserId(), entry.getUserName(), entry.getMode(), entry.isProcess(), entry.getEncoding());
                    nodes.add(node);
                }
                continue;
            }
            if (!this.isEmpty(symLink)) {
                targetName = path.getLastElement();
                parentPath = path.getParentPath();
                this.logSymLink(log);
                node = new DataEntryNode(targetName, parentPath, symLink, entry.getGroupId(), entry.getGroupName(), entry.getUserId(), entry.getUserName(), entry.getMode());
                nodes.add(node);
                continue;
            }
            targetName = path.getLastElement();
            parentPath = path.getParentPath();
            this.logDirectory(log);
            node = new DataEntryNode(targetName, parentPath, entry.getGroupId(), entry.getGroupName(), entry.getUserId(), entry.getUserName(), entry.getMode());
            nodes.add(node);
        }
        return nodes;
    }

    private boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        return false;
    }

    private void logDataEntry(Log log, DataEntry entry) {
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info((CharSequence)("Target path     : " + entry.getTargetPath()));
        if (!this.isEmpty(entry.getSourcePath())) {
            log.info((CharSequence)("   Source path  : " + entry.getSourcePath()));
        }
        if (!this.isEmpty(entry.getSymLinkPath())) {
            log.info((CharSequence)("   SymLink path : " + entry.getSymLinkPath()));
        }
        if (!this.isEmpty(entry.getGroupId())) {
            log.info((CharSequence)("   Group ID     : " + entry.getGroupId()));
        }
        if (!this.isEmpty(entry.getGroupName())) {
            log.info((CharSequence)("   Group name   : " + entry.getGroupName()));
        }
        if (!this.isEmpty(entry.getUserId())) {
            log.info((CharSequence)("   User ID      : " + entry.getUserId()));
        }
        if (!this.isEmpty(entry.getUserName())) {
            log.info((CharSequence)("   User name    : " + entry.getUserName()));
        }
        if (!this.isEmpty(entry.getMode())) {
            log.info((CharSequence)("   Mode         : 0" + Integer.toOctalString(entry.getMode()) + " (Decimal: " + entry.getMode() + ")"));
        }
        log.info((CharSequence)("   Recursive    : " + entry.isRecursive()));
        log.info((CharSequence)("   Process      : " + entry.isProcess()));
        if (!this.isEmpty(entry.getUserName())) {
            log.info((CharSequence)("   Encoding     : " + entry.getEncoding()));
        }
    }

    private void logFileEntries(Log log, List<FileEntry> files, String pattern) {
        if (!log.isInfoEnabled()) {
            return;
        }
        if (files.isEmpty()) {
            log.info((CharSequence)("   File(s) for pattern |" + pattern + "|: No files found."));
        } else {
            log.info((CharSequence)("   File(s) for pattern |" + pattern + "|:"));
            for (FileEntry file : files) {
                String name = file.getName();
                String relativePath = file.getRelativePath();
                if (!this.isEmpty(relativePath)) {
                    name = relativePath + "/" + name;
                }
                if (file.isDirectory()) {
                    log.info((CharSequence)("      " + name));
                    continue;
                }
                log.info((CharSequence)("      " + name + " -> " + file.getSource()));
            }
        }
    }

    private void logSymLink(Log log) {
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info((CharSequence)"   Symbolic link.");
    }

    private void logDirectory(Log log) {
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info((CharSequence)"   Directory.");
    }

    private List<FileEntry> walkTree(File folder, String pattern, Path path, String relativePath, boolean recursive) throws IOException {
        File[] files;
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        if (pattern == null || pattern.isEmpty()) {
            files = folder.listFiles();
        } else {
            WildcardFileFilter filter = new WildcardFileFilter(pattern, recursive);
            files = folder.listFiles(filter);
        }
        if (files == null) {
            throw new IOException("Couldn't read content of directory |" + folder.getAbsolutePath() + "|.");
        }
        for (File file : files) {
            FileEntry entry;
            String name = file.getName();
            if (file.isDirectory()) {
                if (!recursive) continue;
                entry = new FileEntry(name, path, relativePath);
                entries.add(entry);
                Path childPath = path.createChild(name);
                entries.addAll(this.walkTree(file, pattern, childPath, relativePath + "/" + name, recursive));
                continue;
            }
            entry = new FileEntry(file, name, path, relativePath);
            entries.add(entry);
        }
        return entries;
    }

    private class FileEntry {
        private File source;
        private String name;
        private Path parent;
        private String relativePath;

        public FileEntry(File source, String name, Path parent, String relativePath) {
            this.source = source;
            this.name = name;
            this.parent = parent;
            this.relativePath = relativePath;
        }

        public FileEntry(String name, Path parent, String relativePath) {
            this.source = null;
            this.name = name;
            this.parent = parent;
            this.relativePath = relativePath;
        }

        public boolean isDirectory() {
            return this.source == null;
        }

        public File getSource() {
            return this.source;
        }

        public String getName() {
            return this.name;
        }

        public Path getParent() {
            return this.parent;
        }

        public String getRelativePath() {
            return this.relativePath;
        }
    }
}

