/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.List;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.DebianPackageBuilder;
import net.sourceforge.javadpkg.DebianPackageConstants;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.Size;
import net.sourceforge.javadpkg.io.FileMode;
import net.sourceforge.javadpkg.io.FileOwner;
import net.sourceforge.javadpkg.io.impl.FileModeImpl;
import net.sourceforge.javadpkg.io.impl.FileOwnerImpl;
import net.sourceforge.javadpkg.plugin.DataConfigurationParser;
import net.sourceforge.javadpkg.plugin.cfg.DataConfiguration;
import net.sourceforge.javadpkg.plugin.impl.DataEntryNode;
import net.sourceforge.javadpkg.plugin.impl.DataEntryNodeTransformer;
import net.sourceforge.javadpkg.plugin.impl.DataFileSystemNodeVisitor;
import net.sourceforge.javadpkg.plugin.impl.FileInfoImpl;
import net.sourceforge.javadpkg.plugin.impl.FileSystemNodeInfo;
import net.sourceforge.javadpkg.plugin.io.FileSystemNode;
import net.sourceforge.javadpkg.plugin.io.Path;
import net.sourceforge.javadpkg.plugin.io.impl.FileSystemNodeImpl;
import net.sourceforge.javadpkg.plugin.io.impl.PathImpl;
import net.sourceforge.javadpkg.replace.Replacements;
import org.apache.maven.plugin.logging.Log;

public class DataConfigurationParserImpl
implements DataConfigurationParser,
DebianPackageConstants {
    private static final DecimalFormat FORMAT = new DecimalFormat("###,###,###,##0");
    private Charset defaultEncoding;
    private Replacements replacements;
    private DataEntryNodeTransformer transformer;

    public DataConfigurationParserImpl(Charset defaultEncoding, Replacements replacements) {
        if (defaultEncoding == null) {
            throw new IllegalArgumentException("Argument defaultEncoding is null.");
        }
        if (replacements == null) {
            throw new IllegalArgumentException("Argument replacements is null.");
        }
        this.defaultEncoding = defaultEncoding;
        this.replacements = replacements;
        this.transformer = new DataEntryNodeTransformer();
    }

    @Override
    public Size parseDataConfiguration(Log log, DataConfiguration configuration, DebianPackageBuilder builder, Context context) throws IOException, ParseException {
        if (configuration == null) {
            throw new IllegalArgumentException("Argument configuration is null.");
        }
        if (builder == null) {
            throw new IllegalArgumentException("Argument builder is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        FileSystemNode<FileSystemNodeInfo> root = this.parseDataConfiguration(log, configuration);
        if (log.isInfoEnabled()) {
            log.info((CharSequence)"Add files...");
        }
        DataFileSystemNodeVisitor visitor = new DataFileSystemNodeVisitor(log, builder, this.defaultEncoding, this.replacements, context);
        root.walkNodeTree(visitor);
        if (log.isInfoEnabled()) {
            log.info((CharSequence)("Size        : " + FORMAT.format(visitor.getSize()) + " byte(s)"));
            if (visitor.isProcess()) {
                log.info((CharSequence)"   Attention: Size can differ from real size as at least one file is marked for being processed.");
            }
            log.info((CharSequence)("Files       : " + FORMAT.format(visitor.getFiles())));
            log.info((CharSequence)("Directories : " + FORMAT.format(visitor.getDirectories())));
        }
        Size installedSize = Size.getSizeInBytes((long)visitor.getSize());
        return installedSize;
    }

    private FileSystemNode<FileSystemNodeInfo> parseDataConfiguration(Log log, DataConfiguration configuration) throws IOException, ParseException {
        String name = null;
        FileSystemNode<FileSystemNodeInfo> root = this.createDefaultFileSystem();
        List<DataEntryNode> nodes = this.transformer.transform(log, configuration.getEntries());
        for (DataEntryNode node : nodes) {
            FileSystemNode<FileSystemNodeInfo> parentNode;
            File source = node.getSource();
            name = node.getName();
            Path parent = node.getParent();
            try {
                parentNode = root.createDirectories(parent);
            }
            catch (IllegalStateException e) {
                throw new ParseException("Couldn't ensure existence of parent path |" + parent.getAbsolutePath() + "|: " + e.getMessage(), (Throwable)e);
            }
            String symLink = node.getSymLink();
            Path target = symLink != null ? PathImpl.parsePath(symLink) : null;
            long groupId = node.getGroupId() == null ? 0L : node.getGroupId();
            String groupName = node.getGroupName() == null ? "root" : node.getGroupName();
            long userId = node.getUserId() == null ? 0L : node.getUserId();
            String userName = node.getUserName() == null ? "root" : node.getUserName();
            int modeValue = node.getMode() == null ? (source == null ? 493 : 420) : node.getMode();
            FileOwnerImpl owner = new FileOwnerImpl(groupId, groupName, userId, userName);
            FileModeImpl mode = new FileModeImpl(modeValue);
            try {
                if (source != null) {
                    this.removeExistingNode(log, parentNode, name, false);
                    FileSystemNodeInfo info = new FileSystemNodeInfo(new FileInfoImpl(source), node.isProcess(), node.getEncoding());
                    parentNode.createChildFile(name, (FileOwner)owner, (FileMode)mode, info);
                    continue;
                }
                if (symLink != null) {
                    this.removeExistingNode(log, parentNode, name, false);
                    parentNode.createChildSymLink(name, target, (FileOwner)owner, (FileMode)mode, null);
                    continue;
                }
                this.removeExistingNode(log, parentNode, name, true);
                parentNode.createChildDirectory(name, (FileOwner)owner, (FileMode)mode, null);
            }
            catch (IllegalStateException e) {
                throw new ParseException("Couldn't create node |" + name + "| in path |" + parentNode.getPath().getAbsolutePath() + "|: " + e.getMessage(), (Throwable)e);
            }
        }
        return root;
    }

    private FileSystemNode<FileSystemNodeInfo> createDefaultFileSystem() {
        FileSystemNodeImpl<FileSystemNodeInfo> root = new FileSystemNodeImpl<FileSystemNodeInfo>("");
        root.createDirectories(PathImpl.parsePath("/bin"));
        root.createDirectories(PathImpl.parsePath("/boot"));
        root.createDirectories(PathImpl.parsePath("/etc"));
        root.createDirectories(PathImpl.parsePath("/lib"));
        root.createDirectories(PathImpl.parsePath("/opt"));
        root.createDirectories(PathImpl.parsePath("/run"));
        root.createDirectories(PathImpl.parsePath("/sbin"));
        root.createDirectories(PathImpl.parsePath("/srv"));
        root.createDirectories(PathImpl.parsePath("/usr"));
        root.createDirectories(PathImpl.parsePath("/usr/bin"));
        root.createDirectories(PathImpl.parsePath("/usr/include"));
        root.createDirectories(PathImpl.parsePath("/usr/lib"));
        root.createDirectories(PathImpl.parsePath("/usr/local"));
        root.createDirectories(PathImpl.parsePath("/usr/sbin"));
        root.createDirectories(PathImpl.parsePath("/usr/share"));
        root.createDirectories(PathImpl.parsePath("/usr/src"));
        root.createDirectories(PathImpl.parsePath("/usr/X11R6"));
        root.createDirectories(PathImpl.parsePath("/var"));
        root.createDirectories(PathImpl.parsePath("/var/cache"));
        root.createDirectories(PathImpl.parsePath("/var/lib"));
        root.createDirectories(PathImpl.parsePath("/var/lock"));
        root.createDirectories(PathImpl.parsePath("/var/log"));
        root.createDirectories(PathImpl.parsePath("/var/mail"));
        root.createDirectories(PathImpl.parsePath("/var/opt"));
        root.createDirectories(PathImpl.parsePath("/var/run"));
        root.createDirectories(PathImpl.parsePath("/var/spool"));
        root.createDirectories(PathImpl.parsePath("/var/spool/mail"));
        return root;
    }

    private void removeExistingNode(Log log, FileSystemNode<FileSystemNodeInfo> parentNode, String name, boolean directory) throws ParseException {
        FileSystemNode<FileSystemNodeInfo> previousNode = parentNode.getChild(name);
        if (previousNode != null) {
            if (previousNode.isDirectory() != directory) {
                throw new ParseException("The existing node |" + previousNode.getPath().getAbsolutePath() + "| should be replaced, but the existing node is a " + (directory ? "directory" : "file") + " node while the replacement is not.");
            }
            parentNode.removeChild(previousNode);
            if (log.isInfoEnabled()) {
                log.info((CharSequence)("Existing node |" + previousNode.getPath().getAbsolutePath() + "| is replaced."));
            }
        }
    }
}

