/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.File;
import java.io.IOException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Copyright;
import net.sourceforge.javadpkg.CopyrightLicense;
import net.sourceforge.javadpkg.CopyrightParser;
import net.sourceforge.javadpkg.FilesCopyright;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.impl.CopyrightImpl;
import net.sourceforge.javadpkg.impl.CopyrightLicenseImpl;
import net.sourceforge.javadpkg.impl.CopyrightParserImpl;
import net.sourceforge.javadpkg.impl.FilesCopyrightImpl;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.impl.DataFileSource;
import net.sourceforge.javadpkg.plugin.CopyrightConfigurationParser;
import net.sourceforge.javadpkg.plugin.cfg.CopyrightConfiguration;
import net.sourceforge.javadpkg.plugin.cfg.CopyrightFilesConfiguration;
import net.sourceforge.javadpkg.plugin.cfg.CopyrightLicenseConfiguration;
import org.apache.maven.plugin.logging.Log;

public class CopyrightConfigurationParserImpl
implements CopyrightConfigurationParser {
    private CopyrightParser copyrightParser = new CopyrightParserImpl();

    @Override
    public Copyright parseCopyrightConfiguration(Log log, CopyrightConfiguration config, Context context) throws IOException, ParseException {
        if (config == null) {
            throw new IllegalArgumentException("Argument config is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        File file = config.getFile();
        Copyright copyright = file != null ? this.parseFile(log, file, context) : this.parseConfiguration(log, config, context);
        return copyright;
    }

    private Copyright parseFile(Log log, File file, Context context) throws IOException, ParseException {
        Copyright copyright;
        if (log.isInfoEnabled()) {
            log.info((CharSequence)("Read copyright from file |" + file.getAbsolutePath() + "|."));
        }
        try (DataFileSource source = new DataFileSource(file);){
            copyright = this.copyrightParser.parseCopyright((DataSource)source, context);
        }
        catch (IOException e) {
            throw new IOException("Couldn't parse the copyright file |" + file.getAbsolutePath() + "|: " + e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new IOException("Couldn't parse the copyright file |" + file.getAbsolutePath() + "|: " + e.getMessage(), e);
        }
        return copyright;
    }

    private Copyright parseConfiguration(Log log, CopyrightConfiguration config, Context context) throws ParseException {
        if (log.isInfoEnabled()) {
            log.info((CharSequence)"Read copyright from configuration.");
        }
        CopyrightImpl copyright = new CopyrightImpl();
        copyright.setUpstreamName(config.getUpstreamName());
        copyright.setUpstreamContact(config.getUpstreamContact());
        copyright.setSource(config.getSource());
        copyright.setDisclaimer(config.getDisclaimer());
        copyright.setComment(config.getComment());
        copyright.setLicense(this.parseLicenseConfiguration(config.getLicense(), context));
        copyright.setCopyright(config.getCopyright());
        for (CopyrightFilesConfiguration copyrightFilesConfiguration : config.getFiles()) {
            FilesCopyright filesCopyright = this.parseFilesConfiguration(copyrightFilesConfiguration, context);
            copyright.addFilesCopyright(filesCopyright);
        }
        for (CopyrightLicenseConfiguration copyrightLicenseConfiguration : config.getLicenses()) {
            CopyrightLicense license = this.parseLicenseConfiguration(copyrightLicenseConfiguration, context);
            copyright.addLicense(license);
        }
        return copyright;
    }

    private CopyrightLicense parseLicenseConfiguration(CopyrightLicenseConfiguration config, Context context) throws ParseException {
        if (config == null) {
            return null;
        }
        CopyrightLicenseImpl license = new CopyrightLicenseImpl();
        license.setName(config.getName());
        license.setText(config.getText());
        return license;
    }

    private FilesCopyright parseFilesConfiguration(CopyrightFilesConfiguration config, Context context) throws ParseException {
        if (config == null) {
            return null;
        }
        FilesCopyrightImpl files = new FilesCopyrightImpl();
        files.setFiles(config.getFiles());
        files.setCopyright(config.getCopyright());
        files.setLicense(this.parseLicenseConfiguration(config.getLicense(), context));
        files.setComment(config.getComment());
        return files;
    }
}

