/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.javadpkg.ChangeLog;
import net.sourceforge.javadpkg.ChangeLogConstants;
import net.sourceforge.javadpkg.ChangeLogParser;
import net.sourceforge.javadpkg.ChangeLogUrgencyParser;
import net.sourceforge.javadpkg.ChangeLogVersionEntry;
import net.sourceforge.javadpkg.ChangeLogVersionEntryDetail;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackageMaintainerParser;
import net.sourceforge.javadpkg.control.PackageNameParser;
import net.sourceforge.javadpkg.control.PackageVersionParser;
import net.sourceforge.javadpkg.control.impl.PackageMaintainerParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageNameParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionParserImpl;
import net.sourceforge.javadpkg.impl.ChangeLogImpl;
import net.sourceforge.javadpkg.impl.ChangeLogParserImpl;
import net.sourceforge.javadpkg.impl.ChangeLogUrgencyParserImpl;
import net.sourceforge.javadpkg.impl.ChangeLogVersionEntryDetailImpl;
import net.sourceforge.javadpkg.impl.ChangeLogVersionEntryImpl;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.impl.DataFileSource;
import net.sourceforge.javadpkg.plugin.ChangeLogConfigurationParser;
import net.sourceforge.javadpkg.plugin.cfg.ChangeLogConfiguration;
import net.sourceforge.javadpkg.plugin.cfg.ChangeLogVersionEntryConfiguration;
import org.apache.maven.plugin.logging.Log;

public class ChangeLogConfigurationParserImpl
implements ChangeLogConfigurationParser,
ChangeLogConstants {
    private ChangeLogParser changeLogParser = new ChangeLogParserImpl();
    private PackageNameParser packageNameParser = new PackageNameParserImpl();
    private PackageVersionParser packageVersionParser = new PackageVersionParserImpl();
    private ChangeLogUrgencyParser changeLogUrgencyParser = new ChangeLogUrgencyParserImpl();
    private PackageMaintainerParser packageMaintainerParser = new PackageMaintainerParserImpl();

    @Override
    public ChangeLog parseChangeLogConfiguration(Log log, ChangeLogConfiguration config, Context context) throws IOException, ParseException {
        if (config == null) {
            throw new IllegalArgumentException("Argument config is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        File file = config.getFile();
        ChangeLog changeLog = file != null ? this.parseFile(log, file, context) : this.parseConfiguration(log, config, context);
        return changeLog;
    }

    private ChangeLog parseFile(Log log, File file, Context context) throws IOException, ParseException {
        ChangeLog changeLog;
        if (log.isInfoEnabled()) {
            log.info((CharSequence)("Read change log from file |" + file.getAbsolutePath() + "|."));
        }
        try (DataFileSource source = new DataFileSource(file);){
            changeLog = this.changeLogParser.parseChangeLog((DataSource)source, context);
        }
        catch (IOException e) {
            throw new IOException("Couldn't parse the change log file |" + file.getAbsolutePath() + "|: " + e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new IOException("Couldn't parse the change log file |" + file.getAbsolutePath() + "|: " + e.getMessage(), e);
        }
        return changeLog;
    }

    private ChangeLog parseConfiguration(Log log, ChangeLogConfiguration config, Context context) throws ParseException {
        if (log.isInfoEnabled()) {
            log.info((CharSequence)"Read change log from configuration.");
        }
        ChangeLogImpl changeLog = new ChangeLogImpl();
        for (ChangeLogVersionEntryConfiguration cfg : config.getEntries()) {
            ChangeLogVersionEntry entry = this.parseVersionEntryConfiguration(cfg, context);
            changeLog.addEntry(entry);
        }
        return changeLog;
    }

    private ChangeLogVersionEntry parseVersionEntryConfiguration(ChangeLogVersionEntryConfiguration config, Context context) throws ParseException {
        ChangeLogVersionEntryImpl entry = new ChangeLogVersionEntryImpl();
        entry.setPackageName(this.packageNameParser.parsePackageName(config.getName(), context));
        entry.setVersion(this.packageVersionParser.parsePackageVersion(config.getVersion(), context));
        entry.setDistributions(config.getDistributions());
        entry.setUrgency(this.changeLogUrgencyParser.parseChangeLogUrgency(config.getUrgency(), context));
        entry.setDetails(this.parseDetails(config.getDetails(), context));
        entry.setMaintainer(this.packageMaintainerParser.parsePackageMaintainer(config.getMaintainer(), context));
        try {
            entry.setDate(TIMESTAMP_FORMAT.parse(config.getDate()));
        }
        catch (java.text.ParseException e) {
            throw new ParseException("Couldn't parse timestamp |" + config.getDate() + "| of version entry: " + e.getMessage(), (Throwable)e);
        }
        return entry;
    }

    private List<ChangeLogVersionEntryDetail> parseDetails(List<String> configs, Context context) throws ParseException {
        ArrayList<ChangeLogVersionEntryDetail> details = new ArrayList<ChangeLogVersionEntryDetail>(configs.size());
        for (String config : configs) {
            ChangeLogVersionEntryDetailImpl detail = new ChangeLogVersionEntryDetailImpl(config);
            details.add((ChangeLogVersionEntryDetail)detail);
        }
        return details;
    }
}

