/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.Warning;
import net.sourceforge.javadpkg.control.Architecture;
import net.sourceforge.javadpkg.control.ArchitectureParser;
import net.sourceforge.javadpkg.control.BinaryControl;
import net.sourceforge.javadpkg.control.Description;
import net.sourceforge.javadpkg.control.DescriptionParser;
import net.sourceforge.javadpkg.control.Homepage;
import net.sourceforge.javadpkg.control.HomepageParser;
import net.sourceforge.javadpkg.control.PackageDependency;
import net.sourceforge.javadpkg.control.PackageDependencyParser;
import net.sourceforge.javadpkg.control.PackageMaintainer;
import net.sourceforge.javadpkg.control.PackageMaintainerParser;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageNameParser;
import net.sourceforge.javadpkg.control.PackagePriority;
import net.sourceforge.javadpkg.control.PackagePriorityParser;
import net.sourceforge.javadpkg.control.PackageVersion;
import net.sourceforge.javadpkg.control.PackageVersionParser;
import net.sourceforge.javadpkg.control.PackageVersionRelationOperatorParser;
import net.sourceforge.javadpkg.control.Section;
import net.sourceforge.javadpkg.control.SectionParser;
import net.sourceforge.javadpkg.control.Size;
import net.sourceforge.javadpkg.control.impl.ArchitectureParserImpl;
import net.sourceforge.javadpkg.control.impl.BinaryControlImpl;
import net.sourceforge.javadpkg.control.impl.DescriptionParserImpl;
import net.sourceforge.javadpkg.control.impl.HomepageParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageDependencyParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageMaintainerParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageNameParserImpl;
import net.sourceforge.javadpkg.control.impl.PackagePriorityParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionRelationOperatorParserImpl;
import net.sourceforge.javadpkg.control.impl.SectionParserImpl;
import net.sourceforge.javadpkg.field.FieldType;
import net.sourceforge.javadpkg.plugin.BinaryControlBuilder;
import net.sourceforge.javadpkg.plugin.ControlRecommendedFieldNotSetWarning;
import net.sourceforge.javadpkg.plugin.cfg.ControlConfiguration;
import net.sourceforge.javadpkg.plugin.cfg.DependenciesConfiguration;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class BinaryControlBuilderImpl
implements BinaryControlBuilder {
    private PackageNameParser packageNameParser = new PackageNameParserImpl();
    private PackageVersionParser packageVersionParser = new PackageVersionParserImpl();
    private ArchitectureParser architectureParser = new ArchitectureParserImpl();
    private SectionParser sectionParser = new SectionParserImpl();
    private PackagePriorityParser packagePriorityParser = new PackagePriorityParserImpl();
    private PackageDependencyParser packageDependencyParser = new PackageDependencyParserImpl(this.packageNameParser, (PackageVersionRelationOperatorParser)new PackageVersionRelationOperatorParserImpl(), this.packageVersionParser);
    private PackageMaintainerParser packageMaintainerParser = new PackageMaintainerParserImpl();
    private HomepageParser homepageParser = new HomepageParserImpl();
    private DescriptionParser descriptionParser = new DescriptionParserImpl();

    @Override
    public BinaryControl buildBinaryControl(Log log, ControlConfiguration config, Size installedSize, Context context) throws MojoExecutionException, MojoFailureException {
        List<PackageDependency> dependencies;
        if (log == null) {
            throw new IllegalArgumentException("Argument log is null.");
        }
        if (config == null) {
            throw new IllegalArgumentException("Argument config is null.");
        }
        if (installedSize == null) {
            throw new IllegalArgumentException("Argument installedSize is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        BinaryControlImpl control = new BinaryControlImpl();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Name           : " + config.getName()));
            log.debug((CharSequence)("Version        : " + config.getVersion()));
            log.debug((CharSequence)("Architecture   : " + config.getArchitecture()));
            log.debug((CharSequence)("Section        : " + config.getSection()));
            log.debug((CharSequence)("Priority       : " + config.getPriority()));
            log.debug((CharSequence)("Installed Size : " + config.getInstalledSize()));
            this.log(log, "Depends", config.getDepends());
            this.log(log, "Recommends", config.getRecommends());
            this.log(log, "Suggest", config.getSuggests());
            this.log(log, "Enhances", config.getEnhances());
            this.log(log, "Pre-Depends", config.getPreDepends());
            this.log(log, "Breaks", config.getBreaks());
            this.log(log, "Conflicts", config.getConflicts());
            this.log(log, "Provides", config.getProvides());
            this.log(log, "Replaces", config.getReplaces());
            this.log(log, "Built-Using", config.getBuiltUsing());
            log.debug((CharSequence)("Maintainer     : " + config.getMaintainer()));
            log.debug((CharSequence)("Homepage       : " + config.getHomepage()));
            log.debug((CharSequence)("Description    : " + config.getDescription()));
        }
        if (this.isNotNull("name", config.getName(), FieldType.MANDATORY, context)) {
            PackageName packageName;
            try {
                packageName = this.packageNameParser.parsePackageName(config.getName(), context);
            }
            catch (ParseException e) {
                throw new MojoFailureException("Couldn't parse field of type |name|: " + e.getMessage(), (Throwable)e);
            }
            control.setPackage(packageName);
        }
        if (this.isNotNull("version", config.getVersion(), FieldType.MANDATORY, context)) {
            PackageVersion version;
            try {
                version = this.packageVersionParser.parsePackageVersion(config.getVersion(), context);
            }
            catch (ParseException e) {
                throw new MojoFailureException("Couldn't parse field of type |version|: " + e.getMessage(), (Throwable)e);
            }
            control.setVersion(version);
        }
        if (this.isNotNull("architecture", config.getArchitecture(), FieldType.MANDATORY, context)) {
            Architecture architecture;
            try {
                architecture = this.architectureParser.parseArchitecture(config.getArchitecture(), context);
            }
            catch (ParseException e) {
                throw new MojoFailureException("Couldn't parse field of type |architecture|: " + e.getMessage(), (Throwable)e);
            }
            control.setArchitecture(architecture);
        }
        if (this.isNotNull("section", config.getSection(), FieldType.RECOMMENDED, context)) {
            Section section;
            try {
                section = this.sectionParser.parseSection(config.getSection(), context);
            }
            catch (ParseException e) {
                throw new MojoFailureException("Couldn't parse field of type |section|: " + e.getMessage(), (Throwable)e);
            }
            control.setSection(section);
        }
        if (this.isNotNull("priority", config.getPriority(), FieldType.RECOMMENDED, context)) {
            PackagePriority priority;
            try {
                priority = this.packagePriorityParser.parsePackagePriority(config.getPriority(), context);
            }
            catch (ParseException e) {
                throw new MojoFailureException("Couldn't parse field of type |priority|: " + e.getMessage(), (Throwable)e);
            }
            control.setPriority(priority);
        }
        Size size = this.parseInstalledSize(config.getInstalledSize(), installedSize);
        control.setInstalledSize(size);
        if (this.isNotNull("depends", config.getDepends(), FieldType.OPTIONAL, context)) {
            dependencies = this.parsePackageDependencies("depends", config.getDepends(), context);
            control.setDepends(dependencies);
        }
        if (this.isNotNull("recommends", config.getRecommends(), FieldType.OPTIONAL, context)) {
            dependencies = this.parsePackageDependencies("recommends", config.getRecommends(), context);
            control.setRecommends(dependencies);
        }
        if (this.isNotNull("suggests", config.getSuggests(), FieldType.OPTIONAL, context)) {
            dependencies = this.parsePackageDependencies("suggests", config.getSuggests(), context);
            control.setSuggests(dependencies);
        }
        if (this.isNotNull("enhances", config.getEnhances(), FieldType.OPTIONAL, context)) {
            dependencies = this.parsePackageDependencies("enhances", config.getEnhances(), context);
            control.setEnhances(dependencies);
        }
        if (this.isNotNull("preDepends", config.getPreDepends(), FieldType.OPTIONAL, context)) {
            dependencies = this.parsePackageDependencies("preDepends", config.getPreDepends(), context);
            control.setPreDepends(dependencies);
        }
        if (this.isNotNull("breaks", config.getBreaks(), FieldType.OPTIONAL, context)) {
            dependencies = this.parsePackageDependencies("breaks", config.getBreaks(), context);
            control.setBreaks(dependencies);
        }
        if (this.isNotNull("conflicts", config.getConflicts(), FieldType.OPTIONAL, context)) {
            dependencies = this.parsePackageDependencies("conflicts", config.getConflicts(), context);
            control.setConflicts(dependencies);
        }
        if (this.isNotNull("provides", config.getProvides(), FieldType.OPTIONAL, context)) {
            dependencies = this.parsePackageDependencies("provides", config.getProvides(), context);
            control.setProvides(dependencies);
        }
        if (this.isNotNull("replaces", config.getReplaces(), FieldType.OPTIONAL, context)) {
            dependencies = this.parsePackageDependencies("replaces", config.getReplaces(), context);
            control.setReplaces(dependencies);
        }
        if (this.isNotNull("builtUsing", config.getBuiltUsing(), FieldType.OPTIONAL, context)) {
            dependencies = this.parsePackageDependencies("builtUsing", config.getBuiltUsing(), context);
            control.setBuiltUsing(dependencies);
        }
        if (this.isNotNull("maintainer", config.getMaintainer(), FieldType.MANDATORY, context)) {
            PackageMaintainer maintainer;
            try {
                maintainer = this.packageMaintainerParser.parsePackageMaintainer(config.getMaintainer(), context);
            }
            catch (ParseException e) {
                throw new MojoFailureException("Couldn't parse field of type |maintainer|: " + e.getMessage(), (Throwable)e);
            }
            control.setMaintainer(maintainer);
        }
        if (this.isNotNull("homepage", config.getHomepage(), FieldType.OPTIONAL, context)) {
            Homepage homepage;
            try {
                homepage = this.homepageParser.parseHomepage(config.getHomepage(), context);
            }
            catch (ParseException e) {
                throw new MojoFailureException("Couldn't parse field of type |homepage|: " + e.getMessage(), (Throwable)e);
            }
            control.setHomepage(homepage);
        }
        if (this.isNotNull("description", config.getDescription(), FieldType.MANDATORY, context)) {
            Description description;
            try {
                description = this.descriptionParser.parseDescription(config.getDescription(), context);
            }
            catch (ParseException e) {
                throw new MojoFailureException("Couldn't parse field of type |description|: " + e.getMessage(), (Throwable)e);
            }
            control.setDescription(description);
        }
        return control;
    }

    private void log(Log log, String name, DependenciesConfiguration depCfg) {
        List<String> dependencies = null;
        if (log.isDebugEnabled()) {
            if (depCfg != null) {
                dependencies = depCfg.getDependencies();
            }
            if (dependencies == null || dependencies.isEmpty()) {
                log.debug((CharSequence)String.format("%-14s : No dependencies configured.", name));
            } else {
                log.debug((CharSequence)String.format("%-14s :", name));
                for (String value : dependencies) {
                    log.debug((CharSequence)("   " + value));
                }
            }
        }
    }

    private boolean isNotNull(String propertyName, Object propertyValue, FieldType type, Context context) throws MojoFailureException {
        if (propertyValue == null) {
            switch (type) {
                case MANDATORY: {
                    throw new MojoFailureException("The mandatory field |" + propertyName + "| is not set.");
                }
                case RECOMMENDED: {
                    context.addWarning((Warning)new ControlRecommendedFieldNotSetWarning(propertyName));
                    break;
                }
                case OPTIONAL: {
                    break;
                }
            }
            return false;
        }
        return true;
    }

    private Size parseInstalledSize(String config, Size installedSize) throws MojoExecutionException {
        Size result;
        if (config == null) {
            result = installedSize;
        } else {
            long valueLong;
            boolean overhead = config.startsWith("+");
            String value = overhead ? config.substring(1) : config;
            try {
                valueLong = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new MojoExecutionException("Couldn't parse number |" + value + "| of installed-size |" + config + "|: " + e.getMessage(), (Exception)e);
            }
            result = overhead ? new Size(valueLong + installedSize.getBytes()) : new Size(valueLong);
        }
        return result;
    }

    private List<PackageDependency> parsePackageDependencies(String propertyName, DependenciesConfiguration config, Context context) throws MojoExecutionException {
        ArrayList<PackageDependency> dependencies = new ArrayList<PackageDependency>();
        for (String cfg : config.getDependencies()) {
            PackageDependency dependency;
            try {
                dependency = this.packageDependencyParser.parsePackageDependency(cfg, context);
            }
            catch (ParseException e) {
                throw new MojoExecutionException("Couldn't parse dependency |" + cfg + "| of type |" + propertyName + "|: " + e.getMessage(), (Exception)((Object)e));
            }
            dependencies.add(dependency);
        }
        return dependencies;
    }
}

