/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin;

import java.util.Map;
import net.sourceforge.javadpkg.plugin.reflect.PropertyReflection;
import net.sourceforge.javadpkg.plugin.reflect.PropertyReflectionException;
import net.sourceforge.javadpkg.plugin.reflect.PropertyReflectionImpl;
import net.sourceforge.javadpkg.replace.ReplacementException;
import net.sourceforge.javadpkg.replace.Replacements;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public class ReplacementsMaven
implements Replacements {
    private static final String PROJECT_VAR = "project";
    private static final String PROJECT_VAR_PREFIX = "project.";
    private static final String SETTINGS_VAR = "settings";
    private static final String SETTINGS_VAR_PREFIX = "settings.";
    private static final String ENV_VAR = "env";
    private static final String ENV_VAR_PREFIX = "env.";
    private Map<Object, Object> pluginProperties;
    private MavenProject project;
    private Settings settings;
    private Map<String, String> environment;
    private Map<Object, Object> systemProperties;
    private PropertyReflection propertyReflection;

    public ReplacementsMaven(Map<Object, Object> pluginProperties, MavenProject project, Settings settings, Map<String, String> environment, Map<Object, Object> systemProperties) {
        if (pluginProperties == null) {
            throw new IllegalArgumentException("Argument pluginProperties is null.");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument project is null.");
        }
        if (settings == null) {
            throw new IllegalArgumentException("Argument settings is null.");
        }
        if (environment == null) {
            throw new IllegalArgumentException("Argument environment is null.");
        }
        if (systemProperties == null) {
            throw new IllegalArgumentException("Argument systemProperties is null.");
        }
        this.pluginProperties = pluginProperties;
        this.project = project;
        this.settings = settings;
        this.environment = environment;
        this.systemProperties = systemProperties;
        this.propertyReflection = new PropertyReflectionImpl();
    }

    public String getValue(String name) throws ReplacementException {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        Object value = this.getMapValue(this.pluginProperties, null, name);
        if (value == null) {
            value = this.getMapValue(this.project.getProperties(), null, name);
        }
        if (value == null) {
            value = PROJECT_VAR.equals(name) || name.startsWith(PROJECT_VAR_PREFIX) ? this.getProjectValue(name) : (SETTINGS_VAR.equals(name) || name.startsWith(SETTINGS_VAR_PREFIX) ? this.getSettingsValue(name) : (ENV_VAR.equals(name) || name.startsWith(ENV_VAR_PREFIX) ? this.getEnvironmentValue(name) : this.getMapValue(this.systemProperties, null, name)));
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private Object getProjectValue(String name) throws ReplacementException {
        Object value;
        if (PROJECT_VAR.equals(name)) {
            return this.project;
        }
        String path = name.substring(PROJECT_VAR_PREFIX.length());
        try {
            value = this.propertyReflection.getValue(this.project, path);
        }
        catch (PropertyReflectionException e) {
            throw new ReplacementException("Couldn't determine value for variable |" + name + "|: " + e.getMessage(), (Throwable)e);
        }
        return value;
    }

    private Object getSettingsValue(String name) throws ReplacementException {
        Object value;
        if (SETTINGS_VAR.equals(name)) {
            return this.settings;
        }
        String path = name.substring(SETTINGS_VAR_PREFIX.length());
        try {
            value = this.propertyReflection.getValue(this.settings, path);
        }
        catch (PropertyReflectionException e) {
            throw new ReplacementException("Couldn't determine value for variable |" + name + "|: " + e.getMessage(), (Throwable)e);
        }
        return value;
    }

    private Object getEnvironmentValue(String name) {
        if (ENV_VAR.equals(name)) {
            return this.environment;
        }
        String value = this.getMapValue(this.environment, ENV_VAR_PREFIX, name);
        return value;
    }

    private <K, V> V getMapValue(Map<K, V> map, String prefix, String name) {
        if (map.isEmpty()) {
            return null;
        }
        String key = prefix == null || !name.startsWith(prefix) ? name : name.substring(prefix.length());
        V value = map.get(key);
        return value;
    }
}

