/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.ChangeLog;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Copyright;
import net.sourceforge.javadpkg.DebianPackageBuilder;
import net.sourceforge.javadpkg.GlobalConstants;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.Script;
import net.sourceforge.javadpkg.ScriptParser;
import net.sourceforge.javadpkg.ScriptVariableReplacer;
import net.sourceforge.javadpkg.Warning;
import net.sourceforge.javadpkg.control.BinaryControl;
import net.sourceforge.javadpkg.control.Control;
import net.sourceforge.javadpkg.control.Size;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.impl.DebianPackageBuilderFactoryImpl;
import net.sourceforge.javadpkg.impl.ScriptParserImpl;
import net.sourceforge.javadpkg.impl.ScriptVariableReplacerImpl;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.impl.DataFileSource;
import net.sourceforge.javadpkg.io.impl.DataFileTarget;
import net.sourceforge.javadpkg.io.impl.DataStreamSource;
import net.sourceforge.javadpkg.plugin.ChangeLogConfigurationParser;
import net.sourceforge.javadpkg.plugin.CopyrightConfigurationParser;
import net.sourceforge.javadpkg.plugin.ReplacementsMaven;
import net.sourceforge.javadpkg.plugin.TargetFileBuilder;
import net.sourceforge.javadpkg.plugin.cfg.ChangeLogConfiguration;
import net.sourceforge.javadpkg.plugin.cfg.ControlConfiguration;
import net.sourceforge.javadpkg.plugin.cfg.CopyrightConfiguration;
import net.sourceforge.javadpkg.plugin.cfg.DataConfiguration;
import net.sourceforge.javadpkg.plugin.cfg.ScriptConfiguration;
import net.sourceforge.javadpkg.plugin.cfg.ScriptType;
import net.sourceforge.javadpkg.plugin.impl.BinaryControlBuilderImpl;
import net.sourceforge.javadpkg.plugin.impl.ChangeLogConfigurationParserImpl;
import net.sourceforge.javadpkg.plugin.impl.CopyrightConfigurationParserImpl;
import net.sourceforge.javadpkg.plugin.impl.DataConfigurationParserImpl;
import net.sourceforge.javadpkg.plugin.impl.TargetFileBuilderImpl;
import net.sourceforge.javadpkg.replace.ReplacementException;
import net.sourceforge.javadpkg.replace.Replacements;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

@Mojo(name="dpkg", defaultPhase=LifecyclePhase.PACKAGE)
public class DebianPackageMojo
extends AbstractMojo
implements GlobalConstants {
    private static final DecimalFormat FORMAT = new DecimalFormat("###,###,###,##0");
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojo;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor plugin;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File basedir;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File target;
    @Parameter(defaultValue="${project.build.sourceEncoding}", readonly=true)
    private String sourceEncoding;
    @Parameter(name="failOnWarning", defaultValue="true")
    private boolean failOnWarning;
    @Parameter(name="skip", defaultValue="false")
    private boolean skip;
    @Parameter(name="outputDirectory", defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(name="control", required=true)
    private ControlConfiguration control;
    @Parameter(name="scripts")
    private List<ScriptConfiguration> scripts;
    @Parameter(name="copyright", required=true)
    private CopyrightConfiguration copyright;
    @Parameter(name="changeLog", required=true)
    private ChangeLogConfiguration changeLog;
    @Parameter(name="data", required=true)
    private DataConfiguration data;
    @Parameter(name="properties")
    private Properties properties;
    private ScriptParser scriptParser = new ScriptParserImpl();
    private ScriptVariableReplacer scriptVariableReplacer = new ScriptVariableReplacerImpl();
    private CopyrightConfigurationParser copyrightConfigurationParser = new CopyrightConfigurationParserImpl();
    private ChangeLogConfigurationParser changeLogConfigurationParser = new ChangeLogConfigurationParserImpl();

    public void execute() throws MojoExecutionException, MojoFailureException {
        ChangeLog changeLog;
        Copyright copyright;
        Size installedSize;
        DebianPackageBuilderFactoryImpl builderFactory;
        File targetDirectory;
        Log log = this.getLog();
        if (log.isInfoEnabled()) {
            log.info((CharSequence)"dpkg-maven-plugin");
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Session             : " + this.session));
                log.debug((CharSequence)("Project             : " + this.project));
                log.debug((CharSequence)("Mojo                : " + this.mojo));
                log.debug((CharSequence)("Plugin              : " + this.plugin));
                log.debug((CharSequence)("Settings            : " + this.settings));
                log.debug((CharSequence)("Basedir             : " + this.basedir));
                try {
                    log.debug((CharSequence)("Target              : " + (this.target == null ? "null" : this.target.getCanonicalPath())));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Couldn't create canonical path (removing '..'): " + e.getMessage(), (Exception)e);
                }
                try {
                    log.debug((CharSequence)("Output Directory    : " + (this.outputDirectory == null ? "null" : this.outputDirectory.getCanonicalPath())));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Couldn't create canonical path (removing '..'): " + e.getMessage(), (Exception)e);
                }
                if (this.properties == null || this.properties.isEmpty()) {
                    log.debug((CharSequence)"Properties          : No properties defined.");
                } else {
                    log.debug((CharSequence)"Properties          :");
                    for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                        log.debug((CharSequence)String.format("   %-16s : %s", entry.getKey().toString(), entry.getValue() == null ? "null" : entry.getValue().toString()));
                    }
                }
            }
        }
        Charset defaultEncoding = this.getDefaultEncoding();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Default Encoding    : " + defaultEncoding));
        }
        if (this.skip) {
            if (log.isInfoEnabled()) {
                log.info((CharSequence)"Skip.");
            }
            return;
        }
        if (this.control == null) {
            throw new MojoExecutionException("Control configuration of the plugin is not set.");
        }
        if (this.copyright == null) {
            throw new MojoExecutionException("Copyright configuration of the plugin is not set.");
        }
        if (this.changeLog == null) {
            throw new MojoExecutionException("Change log configuration of the plugin is not set.");
        }
        try {
            targetDirectory = this.outputDirectory != null ? this.outputDirectory.getCanonicalFile() : this.target.getCanonicalFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Couldn't create canonical path for target directory |" + (this.outputDirectory == null ? this.target.getAbsolutePath() : this.outputDirectory.getAbsolutePath()) + "|: " + e.getMessage(), (Exception)e);
        }
        Properties pluginProperties = this.properties == null ? new Properties() : this.properties;
        ReplacementsMaven replacements = new ReplacementsMaven(pluginProperties, this.project, this.settings, System.getenv(), System.getProperties());
        try {
            builderFactory = new DebianPackageBuilderFactoryImpl();
        }
        catch (IOException | ParseException e) {
            throw new MojoExecutionException("Couldn't create builder factory: " + e.getMessage(), (Exception)e);
        }
        DebianPackageBuilder builder = builderFactory.createDebianPackageBuilder();
        ContextImpl dataContext = new ContextImpl();
        DataConfigurationParserImpl dataConfigurationParser = new DataConfigurationParserImpl(defaultEncoding, replacements);
        try {
            installedSize = dataConfigurationParser.parseDataConfiguration(log, this.data, builder, (Context)dataContext);
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occured while adding the directories and files: " + e.getMessage(), (Exception)e);
        }
        catch (ParseException e) {
            throw new MojoFailureException("An error occured while adding the directories and files: " + e.getMessage(), (Throwable)e);
        }
        this.logWarnings(log, (Context)dataContext);
        BinaryControlBuilderImpl binaryControlBuilder = new BinaryControlBuilderImpl();
        ContextImpl context = new ContextImpl();
        BinaryControl control = binaryControlBuilder.buildBinaryControl(log, this.control, installedSize, (Context)context);
        builder.setControl((Control)control);
        this.logWarnings(log, (Context)context);
        context = new ContextImpl();
        this.addInstallScripts(log, builder, replacements, (Context)context);
        this.logWarnings(log, (Context)context);
        context = new ContextImpl();
        try {
            copyright = this.copyrightConfigurationParser.parseCopyrightConfiguration(log, this.copyright, (Context)context);
        }
        catch (IOException | ParseException e) {
            throw new MojoExecutionException("Couldn't parse copyright configuration: " + e.getMessage(), (Exception)e);
        }
        builder.setCopyright(copyright);
        this.logWarnings(log, (Context)context);
        context = new ContextImpl();
        try {
            changeLog = this.changeLogConfigurationParser.parseChangeLogConfiguration(log, this.changeLog, (Context)context);
        }
        catch (IOException | ParseException e) {
            throw new MojoExecutionException("Couldn't parse change log configuration: " + e.getMessage(), (Exception)e);
        }
        builder.setChangeLog(changeLog);
        this.logWarnings(log, (Context)context);
        TargetFileBuilderImpl targetFileBuilder = new TargetFileBuilderImpl();
        context = new ContextImpl();
        this.buildDebianPackage(log, builder, targetDirectory, control, targetFileBuilder, (Context)context);
        this.logWarnings(log, (Context)context);
        this.logWarnings(log, (Context)dataContext);
    }

    private Charset getDefaultEncoding() throws MojoExecutionException {
        Charset charset;
        if (this.sourceEncoding != null) {
            try {
                charset = Charset.forName(this.sourceEncoding);
            }
            catch (IllegalArgumentException e) {
                throw new MojoExecutionException("The encoding |" + this.sourceEncoding + "| defined in the pom.xml is not supported by this JVM: " + e.getMessage(), (Exception)e);
            }
        } else {
            charset = Charset.defaultCharset();
        }
        return charset;
    }

    private void addInstallScripts(Log log, DebianPackageBuilder builder, Replacements replacements, Context context) throws MojoExecutionException {
        Script script;
        if (this.scripts == null || this.scripts.isEmpty()) {
            return;
        }
        HashMap<ScriptType, ScriptConfiguration> confs = new HashMap<ScriptType, ScriptConfiguration>();
        for (ScriptConfiguration conf : this.scripts) {
            if (confs.put(conf.getType(), conf) == null) continue;
            throw new MojoExecutionException("The installation script configuration for type |" + (Object)((Object)conf.getType()) + "| exists more than once.");
        }
        HashMap<ScriptType, Script> scripts = new HashMap<ScriptType, Script>();
        for (ScriptConfiguration conf : confs.values()) {
            block41: {
                Throwable throwable;
                DataFileSource source;
                if (conf.getFile() != null) {
                    if (log.isInfoEnabled()) {
                        log.info((CharSequence)("Read installation script for type |" + (Object)((Object)conf.getType()) + "| from file |" + conf.getFile().getAbsolutePath() + "|."));
                    }
                    try {
                        source = new DataFileSource(conf.getFile());
                        throwable = null;
                        try {
                            script = this.scriptParser.parseScript((DataSource)source, context);
                            break block41;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (source != null) {
                                if (throwable != null) {
                                    try {
                                        source.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    source.close();
                                }
                            }
                        }
                    }
                    catch (IOException | ParseException e) {
                        throw new MojoExecutionException("Couldn't parse the installation script configuration for type |" + (Object)((Object)conf.getType()) + "| from file |" + conf.getFile().getAbsolutePath() + "|: " + e.getMessage(), (Exception)e);
                    }
                }
                if (conf.getContent() != null) {
                    if (log.isInfoEnabled()) {
                        log.info((CharSequence)("Read installation script for type |" + (Object)((Object)conf.getType()) + "| from configuration."));
                    }
                    try {
                        source = new DataStreamSource((InputStream)new ByteArrayInputStream(conf.getContent().getBytes(UTF_8_CHARSET)), conf.getType().toString(), true);
                        throwable = null;
                        try {
                            script = this.scriptParser.parseScript((DataSource)source, context);
                            break block41;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (source != null) {
                                if (throwable != null) {
                                    try {
                                        source.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    source.close();
                                }
                            }
                        }
                    }
                    catch (IOException | ParseException e) {
                        throw new MojoExecutionException("Couldn't parse the installation script configuration for type |" + (Object)((Object)conf.getType()) + "| from the <content> element: " + e.getMessage(), (Exception)e);
                    }
                }
                throw new MojoExecutionException("The installation script configuration for type |" + (Object)((Object)conf.getType()) + "| is empty: No <file> and no <content> element is set.");
            }
            try {
                script = this.scriptVariableReplacer.replaceScriptVariables(script, replacements, context);
            }
            catch (ReplacementException e) {
                throw new MojoExecutionException("Couldn't replace the variables in the installation script configuration for type |" + (Object)((Object)conf.getType()) + "|: " + e.getMessage(), (Exception)((Object)e));
            }
            scripts.put(conf.getType(), script);
        }
        script = (Script)scripts.get((Object)ScriptType.PREINST);
        if (script != null) {
            builder.setPreInstall(script);
        }
        if ((script = (Script)scripts.get((Object)ScriptType.POSTINST)) != null) {
            builder.setPostInstall(script);
        }
        if ((script = (Script)scripts.get((Object)ScriptType.PRERM)) != null) {
            builder.setPreRemove(script);
        }
        if ((script = (Script)scripts.get((Object)ScriptType.POSTRM)) != null) {
            builder.setPostRemove(script);
        }
    }

    private void buildDebianPackage(Log log, DebianPackageBuilder builder, File targetDirectory, BinaryControl control, TargetFileBuilder targetFileBuilder, Context context) throws MojoExecutionException, MojoFailureException {
        File targetFile = targetFileBuilder.createTargetFile(targetDirectory, control);
        if (!targetDirectory.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Create directory: " + targetDirectory.getAbsolutePath()));
            }
            if (!targetDirectory.mkdirs()) {
                throw new MojoExecutionException("Couldn't create directory |" + targetDirectory.getAbsolutePath() + "|.");
            }
        }
        if (log.isInfoEnabled()) {
            log.info((CharSequence)("Write Debian package: " + targetFile.getAbsolutePath()));
        }
        try (DataFileTarget target = new DataFileTarget(targetFile);){
            builder.buildDebianPackage((DataTarget)target, context);
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((CharSequence)("Couldn't write Debian package |" + targetFile.getAbsolutePath() + "|: " + e.getMessage()), (Throwable)e);
            }
            throw new MojoFailureException("Couldn't build write package |" + targetFile.getAbsolutePath() + "|: " + e.getMessage(), (Throwable)e);
        }
        catch (BuildException e) {
            if (log.isErrorEnabled()) {
                log.error((CharSequence)("Couldn't build Debian package |" + targetFile.getAbsolutePath() + "|: " + e.getMessage()), (Throwable)e);
            }
            throw new MojoFailureException("Couldn't build Debian package |" + targetFile.getAbsolutePath() + "|: " + e.getMessage(), (Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((CharSequence)("Size of Debian package: " + FORMAT.format(targetFile.length()) + " byte(s)"));
        }
    }

    private void logWarnings(Log log, Context context) throws MojoFailureException {
        List warnings = context.getWarnings();
        if (!warnings.isEmpty()) {
            if (log.isWarnEnabled()) {
                for (Warning warning : warnings) {
                    log.warn((CharSequence)warning.getText());
                }
            }
            if (this.failOnWarning) {
                throw new MojoFailureException("Found " + warnings.size() + " warning(s). First warning: " + ((Warning)warnings.get(0)).getText());
            }
        }
    }
}

