/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.io.impl;

import net.sourceforge.javadpkg.plugin.AbstractDpkgPluginTest;
import net.sourceforge.javadpkg.plugin.io.Path;
import net.sourceforge.javadpkg.plugin.io.impl.PathImpl;
import org.junit.Assert;
import org.junit.Test;

public class PathImplTest
extends AbstractDpkgPluginTest {
    @Test
    public void testPathImpl() {
        PathImpl path = new PathImpl();
        Assert.assertEquals((Object)"/", (Object)path.getAbsolutePath());
        Assert.assertNull((Object)path.getFirstElement());
        Assert.assertNull((Object)path.getLastElement());
        Assert.assertNull((Object)path.getParentPath());
        Assert.assertNull((Object)path.getChildPath());
    }

    @Test
    public void testParsePath() {
        try {
            PathImpl.parsePath(null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Path path = PathImpl.parsePath((String)"");
            Assert.assertNotNull((Object)path);
            Assert.assertEquals((Object)"/", (Object)path.getAbsolutePath());
            Assert.assertNull((Object)path.getFirstElement());
            Assert.assertNull((Object)path.getLastElement());
            Assert.assertNull((Object)path.getParentPath());
            Assert.assertNull((Object)path.getChildPath());
            path = PathImpl.parsePath((String)"/usr/local");
            Assert.assertEquals((Object)"usr", (Object)path.getFirstElement());
            Assert.assertEquals((Object)"local", (Object)path.getLastElement());
            Assert.assertNotNull((Object)path);
            Assert.assertEquals((Object)"/usr/local", (Object)path.getAbsolutePath());
            Path parent = path.getParentPath();
            Assert.assertNotNull((Object)parent);
            Assert.assertEquals((Object)"/usr", (Object)parent.getAbsolutePath());
            Assert.assertEquals((Object)"usr", (Object)parent.getFirstElement());
            Assert.assertEquals((Object)"usr", (Object)parent.getLastElement());
            parent = parent.getParentPath();
            Assert.assertNotNull((Object)parent);
            Assert.assertEquals((Object)"/", (Object)parent.getAbsolutePath());
            Assert.assertNull((Object)parent.getFirstElement());
            Assert.assertNull((Object)parent.getLastElement());
            parent = parent.getParentPath();
            Assert.assertNull((Object)parent);
            Path child = path.getChildPath();
            Assert.assertNotNull((Object)child);
            Assert.assertEquals((Object)"/local", (Object)child.getAbsolutePath());
            Assert.assertEquals((Object)"local", (Object)child.getFirstElement());
            Assert.assertEquals((Object)"local", (Object)child.getLastElement());
            child = child.getChildPath();
            Assert.assertNull((Object)child);
            path = PathImpl.parsePath((String)"/usr/local/");
            Assert.assertEquals((Object)"usr", (Object)path.getFirstElement());
            Assert.assertEquals((Object)"local", (Object)path.getLastElement());
            Assert.assertNotNull((Object)path);
            Assert.assertEquals((Object)"/usr/local", (Object)path.getAbsolutePath());
            parent = path.getParentPath();
            Assert.assertNotNull((Object)parent);
            Assert.assertEquals((Object)"/usr", (Object)parent.getAbsolutePath());
            Assert.assertEquals((Object)"usr", (Object)parent.getFirstElement());
            Assert.assertEquals((Object)"usr", (Object)parent.getLastElement());
            parent = parent.getParentPath();
            Assert.assertNotNull((Object)parent);
            Assert.assertEquals((Object)"/", (Object)parent.getAbsolutePath());
            Assert.assertNull((Object)parent.getFirstElement());
            Assert.assertNull((Object)parent.getLastElement());
            parent = parent.getParentPath();
            Assert.assertNull((Object)parent);
            child = path.getChildPath();
            Assert.assertNotNull((Object)child);
            Assert.assertEquals((Object)"/local", (Object)child.getAbsolutePath());
            Assert.assertEquals((Object)"local", (Object)child.getFirstElement());
            Assert.assertEquals((Object)"local", (Object)child.getLastElement());
            child = child.getChildPath();
            Assert.assertNull((Object)child);
            return;
        }
    }

    @Test
    public void testAddChild() {
        Path path = PathImpl.parsePath((String)"/usr/local");
        Path child = path.createChild("myprogram");
        Assert.assertEquals((Object)"/usr/local", (Object)path.getAbsolutePath());
        Assert.assertEquals((Object)"usr", (Object)path.getFirstElement());
        Assert.assertEquals((Object)"local", (Object)path.getLastElement());
        Assert.assertNotNull((Object)child);
        Assert.assertEquals((Object)"/usr/local/myprogram", (Object)child.getAbsolutePath());
        Assert.assertEquals((Object)"usr", (Object)child.getFirstElement());
        Assert.assertEquals((Object)"myprogram", (Object)child.getLastElement());
    }
}

