/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.io.impl;

import net.sourceforge.javadpkg.plugin.AbstractDpkgPluginTest;
import net.sourceforge.javadpkg.plugin.io.FileSystemNode;
import net.sourceforge.javadpkg.plugin.io.Path;
import net.sourceforge.javadpkg.plugin.io.impl.FileSystemNodeImpl;
import net.sourceforge.javadpkg.plugin.io.impl.PathImpl;
import org.junit.Assert;
import org.junit.Test;

public class FileSystemNodeImplTest
extends AbstractDpkgPluginTest {
    @Test
    public void testFileSystemNodeImplString() {
        FileSystemNodeImpl root = new FileSystemNodeImpl("");
        Assert.assertNull((Object)root.getParent());
        Assert.assertEquals((Object)"", (Object)root.getName());
        Assert.assertEquals((Object)"/", (Object)root.getPath().getAbsolutePath());
        Assert.assertTrue((boolean)root.isDirectory());
        Assert.assertFalse((boolean)root.isFile());
        Assert.assertTrue((boolean)root.isCreatedByDependency());
        Assert.assertTrue((boolean)root.containsOnlyCreatedByDependency());
        FileSystemNodeImpl usr = new FileSystemNodeImpl("usr");
        root.addChild((FileSystemNode)usr);
        Assert.assertSame((Object)root, (Object)usr.getParent());
        Assert.assertEquals((Object)"usr", (Object)usr.getName());
        Assert.assertEquals((Object)"/usr", (Object)usr.getPath().getAbsolutePath());
        Assert.assertTrue((boolean)usr.isDirectory());
        Assert.assertFalse((boolean)usr.isFile());
        Assert.assertTrue((boolean)usr.isCreatedByDependency());
        Assert.assertTrue((boolean)root.containsOnlyCreatedByDependency());
        FileSystemNodeImpl local = new FileSystemNodeImpl("local");
        usr.addChild((FileSystemNode)local);
        Assert.assertSame((Object)usr, (Object)local.getParent());
        Assert.assertEquals((Object)"local", (Object)local.getName());
        Assert.assertEquals((Object)"/usr/local", (Object)local.getPath().getAbsolutePath());
        Assert.assertTrue((boolean)local.isDirectory());
        Assert.assertFalse((boolean)local.isFile());
        Assert.assertTrue((boolean)local.isCreatedByDependency());
        Assert.assertTrue((boolean)root.containsOnlyCreatedByDependency());
    }

    @Test
    public void testCreateDirectories() {
        FileSystemNodeImpl root = new FileSystemNodeImpl("");
        Assert.assertNull((Object)root.getParent());
        Assert.assertEquals((Object)"", (Object)root.getName());
        Assert.assertEquals((Object)"/", (Object)root.getPath().getAbsolutePath());
        Assert.assertTrue((boolean)root.isDirectory());
        Assert.assertFalse((boolean)root.isFile());
        Assert.assertTrue((boolean)root.isCreatedByDependency());
        Assert.assertTrue((boolean)root.containsOnlyCreatedByDependency());
        Path path = PathImpl.parsePath((String)"/usr/local");
        FileSystemNode node = root.createDirectories(path);
        Assert.assertEquals((Object)"local", (Object)node.getName());
        Assert.assertEquals((Object)"/usr/local", (Object)node.getPath().getAbsolutePath());
        Assert.assertTrue((boolean)node.isDirectory());
        Assert.assertFalse((boolean)node.isFile());
        Assert.assertTrue((boolean)node.isCreatedByDependency());
        Assert.assertTrue((boolean)root.containsOnlyCreatedByDependency());
    }

    @Test
    public void testGetNode() {
        FileSystemNodeImpl root = new FileSystemNodeImpl("");
        Assert.assertNull((Object)root.getParent());
        Assert.assertEquals((Object)"", (Object)root.getName());
        Assert.assertEquals((Object)"/", (Object)root.getPath().getAbsolutePath());
        Assert.assertTrue((boolean)root.isDirectory());
        Assert.assertFalse((boolean)root.isFile());
        Assert.assertTrue((boolean)root.isCreatedByDependency());
        Assert.assertTrue((boolean)root.containsOnlyCreatedByDependency());
        Path path = PathImpl.parsePath((String)"/usr/local/myprogram");
        root.createDirectories(path);
        path = PathImpl.parsePath((String)"/");
        FileSystemNode node = root.getNode(path);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"", (Object)node.getName());
        Assert.assertEquals((Object)"/", (Object)node.getPath().getAbsolutePath());
        Assert.assertTrue((boolean)node.isDirectory());
        Assert.assertFalse((boolean)node.isFile());
        Assert.assertTrue((boolean)node.isCreatedByDependency());
        Assert.assertTrue((boolean)root.containsOnlyCreatedByDependency());
        path = PathImpl.parsePath((String)"/usr");
        node = root.getNode(path);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"usr", (Object)node.getName());
        Assert.assertEquals((Object)"/usr", (Object)node.getPath().getAbsolutePath());
        Assert.assertTrue((boolean)node.isDirectory());
        Assert.assertFalse((boolean)node.isFile());
        Assert.assertTrue((boolean)node.isCreatedByDependency());
        Assert.assertTrue((boolean)root.containsOnlyCreatedByDependency());
        path = PathImpl.parsePath((String)"/usr/local");
        node = root.getNode(path);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"local", (Object)node.getName());
        Assert.assertEquals((Object)"/usr/local", (Object)node.getPath().getAbsolutePath());
        Assert.assertTrue((boolean)node.isDirectory());
        Assert.assertFalse((boolean)node.isFile());
        Assert.assertTrue((boolean)node.isCreatedByDependency());
        Assert.assertTrue((boolean)root.containsOnlyCreatedByDependency());
        path = PathImpl.parsePath((String)"/usr/local/myprogram");
        node = root.getNode(path);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"myprogram", (Object)node.getName());
        Assert.assertEquals((Object)"/usr/local/myprogram", (Object)node.getPath().getAbsolutePath());
        Assert.assertTrue((boolean)node.isDirectory());
        Assert.assertFalse((boolean)node.isFile());
        Assert.assertTrue((boolean)node.isCreatedByDependency());
        Assert.assertTrue((boolean)root.containsOnlyCreatedByDependency());
        path = PathImpl.parsePath((String)"/usr/local/myprogram/lib");
        node = root.getNode(path);
        Assert.assertNull((Object)node);
    }
}

