/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.File;
import net.sourceforge.javadpkg.control.Architecture;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageVersion;
import net.sourceforge.javadpkg.plugin.AbstractDpkgPluginTest;
import net.sourceforge.javadpkg.plugin.impl.TargetFileBuilderImpl;
import org.junit.Assert;
import org.junit.Test;

public class TargetFileBuilderImplTest
extends AbstractDpkgPluginTest {
    @Test
    public void test() {
        TargetFileBuilderImpl builder = new TargetFileBuilderImpl();
        File targetDirectory = new File(".");
        PackageName name = TargetFileBuilderImplTest.createPackageName("mypackage");
        PackageVersion version = TargetFileBuilderImplTest.createPackageVersion("1.0");
        Architecture architecture = TargetFileBuilderImplTest.createArchitecture("amd64");
        try {
            builder.createTargetFile(null, name, version, architecture);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                builder.createTargetFile(targetDirectory, null, version, architecture);
                Assert.fail((String)"Expected an exception, but none was thrown.");
                return;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    builder.createTargetFile(targetDirectory, name, null, architecture);
                    Assert.fail((String)"Expected an exception, but none was thrown.");
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    try {
                        builder.createTargetFile(targetDirectory, name, version, null);
                        Assert.fail((String)"Expected an exception, but none was thrown.");
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException4) {
                        File targetFile = builder.createTargetFile(targetDirectory, name, version, architecture);
                        Assert.assertNotNull((Object)targetFile);
                        Assert.assertEquals((Object)"mypackage_1.0_amd64.deb", (Object)targetFile.getName());
                        Assert.assertEquals((Object)".", (Object)targetFile.getParentFile().getPath());
                        return;
                    }
                }
            }
        }
    }
}

