/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.DebianPackageBuilder;
import net.sourceforge.javadpkg.DebianPackageConstants;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.impl.DebianPackageBuilderMock;
import net.sourceforge.javadpkg.io.FileMode;
import net.sourceforge.javadpkg.io.FileOwner;
import net.sourceforge.javadpkg.io.impl.FileModeImpl;
import net.sourceforge.javadpkg.io.impl.FileOwnerImpl;
import net.sourceforge.javadpkg.plugin.AbstractDpkgPluginTest;
import net.sourceforge.javadpkg.plugin.impl.DataFileSystemNodeVisitor;
import net.sourceforge.javadpkg.plugin.impl.FileInfo;
import net.sourceforge.javadpkg.plugin.impl.FileInfoMock;
import net.sourceforge.javadpkg.plugin.impl.FileSystemNodeInfo;
import net.sourceforge.javadpkg.plugin.io.FileSystemNode;
import net.sourceforge.javadpkg.plugin.io.FileSystemNodeVisitor;
import net.sourceforge.javadpkg.plugin.io.impl.FileSystemNodeImpl;
import net.sourceforge.javadpkg.plugin.io.impl.PathImpl;
import net.sourceforge.javadpkg.replace.Replacements;
import org.apache.maven.plugin.logging.Log;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mock;

public class DataFileSystemNodeVisitorTest
extends AbstractDpkgPluginTest
implements DebianPackageConstants {
    private static final Charset DEFAULT_ENCODING = Charset.forName("UTF-8");
    private static final FileModeImpl DEFAULT_DIRECTORY_MODE = new FileModeImpl(493);
    private static final FileModeImpl DEFAULT_SCRIPT_MODE = new FileModeImpl(493);
    private static final FileModeImpl DEFAULT_FILE_MODE = new FileModeImpl(420);
    private static final FileOwnerImpl DEFAULT_OWNER = new FileOwnerImpl(0L, "root", 0L, "root");
    private static final String BASE_DIR = "src/test/resources/net/sourceforge/javadpkg/plugin";
    private static final String BASE_PATH = new File("src/test/resources/net/sourceforge/javadpkg/plugin").getAbsolutePath();
    @Mock
    private Log log;
    @Mock
    private Replacements replacements;

    @Test
    public void test() {
        DebianPackageBuilderMock builder = new DebianPackageBuilderMock();
        ContextImpl context = new ContextImpl();
        try {
            DataFileSystemNodeVisitor visitor = new DataFileSystemNodeVisitor(null, (DebianPackageBuilder)builder, DEFAULT_ENCODING, this.replacements, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                DataFileSystemNodeVisitor visitor = new DataFileSystemNodeVisitor(this.log, null, DEFAULT_ENCODING, this.replacements, (Context)context);
                Assert.fail((String)"Expected an exception, but none was thrown.");
                return;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    DataFileSystemNodeVisitor visitor = new DataFileSystemNodeVisitor(this.log, (DebianPackageBuilder)builder, null, this.replacements, (Context)context);
                    Assert.fail((String)"Expected an exception, but none was thrown.");
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    try {
                        DataFileSystemNodeVisitor visitor = new DataFileSystemNodeVisitor(this.log, (DebianPackageBuilder)builder, DEFAULT_ENCODING, null, (Context)context);
                        Assert.fail((String)"Expected an exception, but none was thrown.");
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException4) {
                        try {
                            DataFileSystemNodeVisitor visitor = new DataFileSystemNodeVisitor(this.log, (DebianPackageBuilder)builder, DEFAULT_ENCODING, this.replacements, null);
                            Assert.fail((String)"Expected an exception, but none was thrown.");
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException5) {
                            FileSystemNode<FileSystemNodeInfo> root = this.createDefaultFileSystem();
                            FileSystemNode parentNode = root.createDirectories(PathImpl.parsePath((String)"/usr/local"));
                            FileSystemNode baseNode = parentNode.createChildDirectory("test", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_DIRECTORY_MODE, null);
                            baseNode.createChildFile("program", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_SCRIPT_MODE, (Object)this.createInfo("src/test/resources/net/sourceforge/javadpkg/plugin/program", 35L, false, null));
                            baseNode.createChildSymLink("other_program", PathImpl.parsePath((String)"/usr/local/test/program"), (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_SCRIPT_MODE, null);
                            parentNode = baseNode.createChildDirectory("lib", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_DIRECTORY_MODE, null);
                            parentNode.createChildFile("library1.lib", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_FILE_MODE, (Object)this.createInfo("src/test/resources/net/sourceforge/javadpkg/plugin/lib/library1.lib", 18L, false, null));
                            parentNode.createChildFile("library2.lib", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_FILE_MODE, (Object)this.createInfo("src/test/resources/net/sourceforge/javadpkg/plugin/lib/library2.lib", 24L, false, null));
                            baseNode.createChildSymLink("lib64", PathImpl.parsePath((String)"/usr/local/test/lib/"), (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_DIRECTORY_MODE, null);
                            parentNode = baseNode.createChildDirectory("ext", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_DIRECTORY_MODE, null);
                            parentNode.createChildFile("ext1.dat", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_FILE_MODE, (Object)this.createInfo("src/test/resources/net/sourceforge/javadpkg/plugin/ext/ext1.dat", 8L, false, null));
                            parentNode = baseNode.createChildDirectory("res", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_DIRECTORY_MODE, null);
                            parentNode = parentNode.createChildDirectory("images", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_DIRECTORY_MODE, null);
                            parentNode.createChildFile("image1.img", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_FILE_MODE, (Object)this.createInfo("src/test/resources/net/sourceforge/javadpkg/plugin/custom_images/image1.img", 6L, false, null));
                            parentNode.createChildFile("image2.img", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_FILE_MODE, (Object)this.createInfo("src/test/resources/net/sourceforge/javadpkg/plugin/custom_images/image2.img", 6L, false, null));
                            parentNode.createChildFile("image3.img", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_FILE_MODE, (Object)this.createInfo("src/test/resources/net/sourceforge/javadpkg/plugin/custom_images/image3.img", 6L, false, null));
                            parentNode = baseNode.getNode(PathImpl.parsePath((String)"res"));
                            parentNode.createChildFile("res1", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_FILE_MODE, (Object)this.createInfo("src/test/resources/net/sourceforge/javadpkg/plugin/res/res1", 4L, false, null));
                            parentNode.createChildFile("res2", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_FILE_MODE, (Object)this.createInfo("src/test/resources/net/sourceforge/javadpkg/plugin/res/res2", 4L, false, null));
                            parentNode = parentNode.createChildDirectory("text", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_DIRECTORY_MODE, null);
                            parentNode.createChildFile("text1.txt", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_FILE_MODE, (Object)this.createInfo("src/test/resources/net/sourceforge/javadpkg/plugin/res/text/text1.txt", 9L, false, null));
                            parentNode.createChildFile("text2.txt", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_FILE_MODE, (Object)this.createInfo("src/test/resources/net/sourceforge/javadpkg/plugin/res/text/text2.txt", 9L, false, null));
                            parentNode.createChildFile("text3.txt", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_FILE_MODE, (Object)this.createInfo("src/test/resources/net/sourceforge/javadpkg/plugin/res/text/text3.txt", 9L, false, null));
                            baseNode.createChildDirectory("template", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_DIRECTORY_MODE, null);
                            parentNode = baseNode.createChildDirectory("conf", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_DIRECTORY_MODE, null);
                            parentNode.createChildFile("conf", (FileOwner)DEFAULT_OWNER, (FileMode)DEFAULT_FILE_MODE, (Object)this.createInfo("src/test/resources/net/sourceforge/javadpkg/plugin/conf/conf.default", 28L, true, "UTF-8"));
                            DataFileSystemNodeVisitor visitor = new DataFileSystemNodeVisitor(this.log, (DebianPackageBuilder)builder, DEFAULT_ENCODING, this.replacements, (Context)context);
                            try {
                                root.walkNodeTree((FileSystemNodeVisitor)visitor);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                Assert.fail((String)("Couldn't walk tree: " + e.getMessage()));
                                return;
                            }
                            Assert.assertEquals((long)166L, (long)visitor.getSize());
                            Assert.assertEquals((long)13L, (long)visitor.getFiles());
                            Assert.assertEquals((long)11L, (long)visitor.getDirectories());
                            Assert.assertEquals((long)2L, (long)visitor.getSymbolicLinks());
                            Assert.assertTrue((boolean)visitor.isProcess());
                            Assert.assertEquals((Object)("drwxr-xr-x     0 root         0 root           null /usr                                    \ndrwxr-xr-x     0 root         0 root           null /usr/local                              \ndrwxr-xr-x     0 root         0 root           null /usr/local/test                         \ndrwxr-xr-x     0 root         0 root           null /usr/local/test/conf                    \n-rw-r--r--     0 root         0 root             26 /usr/local/test/conf/conf                (Source: |" + BASE_PATH + "\\conf\\conf.default|)\ndrwxr-xr-x     0 root         0 root           null /usr/local/test/ext                     \n-rw-r--r--     0 root         0 root              8 /usr/local/test/ext/ext1.dat             (Source: |" + BASE_PATH + "\\ext\\ext1.dat|)\ndrwxr-xr-x     0 root         0 root           null /usr/local/test/lib                     \n-rw-r--r--     0 root         0 root             18 /usr/local/test/lib/library1.lib         (Source: |" + BASE_PATH + "\\lib\\library1.lib|)\n-rw-r--r--     0 root         0 root             24 /usr/local/test/lib/library2.lib         (Source: |" + BASE_PATH + "\\lib\\library2.lib|)\nlrwxr-xr-x     0 root         0 root           null /usr/local/test/lib64                    (Target: |/usr/local/test/lib|)\nlrwxr-xr-x     0 root         0 root           null /usr/local/test/other_program            (Target: |/usr/local/test/program|)\n-rwxr-xr-x     0 root         0 root             35 /usr/local/test/program                  (Source: |" + BASE_PATH + "\\program|)\ndrwxr-xr-x     0 root         0 root           null /usr/local/test/res                     \ndrwxr-xr-x     0 root         0 root           null /usr/local/test/res/images              \n-rw-r--r--     0 root         0 root              6 /usr/local/test/res/images/image1.img    (Source: |" + BASE_PATH + "\\custom_images\\image1.img|)\n-rw-r--r--     0 root         0 root              6 /usr/local/test/res/images/image2.img    (Source: |" + BASE_PATH + "\\custom_images\\image2.img|)\n-rw-r--r--     0 root         0 root              6 /usr/local/test/res/images/image3.img    (Source: |" + BASE_PATH + "\\custom_images\\image3.img|)\n-rw-r--r--     0 root         0 root              4 /usr/local/test/res/res1                 (Source: |" + BASE_PATH + "\\res\\res1|)\n-rw-r--r--     0 root         0 root              4 /usr/local/test/res/res2                 (Source: |" + BASE_PATH + "\\res\\res2|)\ndrwxr-xr-x     0 root         0 root           null /usr/local/test/res/text                \n-rw-r--r--     0 root         0 root              9 /usr/local/test/res/text/text1.txt       (Source: |" + BASE_PATH + "\\res\\text\\text1.txt|)\n-rw-r--r--     0 root         0 root              9 /usr/local/test/res/text/text2.txt       (Source: |" + BASE_PATH + "\\res\\text\\text2.txt|)\n-rw-r--r--     0 root         0 root              9 /usr/local/test/res/text/text3.txt       (Source: |" + BASE_PATH + "\\res\\text\\text3.txt|)\ndrwxr-xr-x     0 root         0 root           null /usr/local/test/template                "), (Object)builder.getDataNodesAsString());
                            return;
                        }
                    }
                }
            }
        }
    }

    private FileSystemNode<FileSystemNodeInfo> createDefaultFileSystem() {
        FileSystemNodeImpl root = new FileSystemNodeImpl("");
        root.createDirectories(PathImpl.parsePath((String)"/bin"));
        root.createDirectories(PathImpl.parsePath((String)"/boot"));
        root.createDirectories(PathImpl.parsePath((String)"/etc"));
        root.createDirectories(PathImpl.parsePath((String)"/lib"));
        root.createDirectories(PathImpl.parsePath((String)"/opt"));
        root.createDirectories(PathImpl.parsePath((String)"/run"));
        root.createDirectories(PathImpl.parsePath((String)"/sbin"));
        root.createDirectories(PathImpl.parsePath((String)"/srv"));
        root.createDirectories(PathImpl.parsePath((String)"/usr"));
        root.createDirectories(PathImpl.parsePath((String)"/usr/bin"));
        root.createDirectories(PathImpl.parsePath((String)"/usr/include"));
        root.createDirectories(PathImpl.parsePath((String)"/usr/lib"));
        root.createDirectories(PathImpl.parsePath((String)"/usr/local"));
        root.createDirectories(PathImpl.parsePath((String)"/usr/sbin"));
        root.createDirectories(PathImpl.parsePath((String)"/usr/share"));
        root.createDirectories(PathImpl.parsePath((String)"/usr/src"));
        root.createDirectories(PathImpl.parsePath((String)"/usr/X11R6"));
        root.createDirectories(PathImpl.parsePath((String)"/var"));
        root.createDirectories(PathImpl.parsePath((String)"/var/cache"));
        root.createDirectories(PathImpl.parsePath((String)"/var/lib"));
        root.createDirectories(PathImpl.parsePath((String)"/var/lock"));
        root.createDirectories(PathImpl.parsePath((String)"/var/log"));
        root.createDirectories(PathImpl.parsePath((String)"/var/mail"));
        root.createDirectories(PathImpl.parsePath((String)"/var/opt"));
        root.createDirectories(PathImpl.parsePath((String)"/var/run"));
        root.createDirectories(PathImpl.parsePath((String)"/var/spool"));
        root.createDirectories(PathImpl.parsePath((String)"/var/spool/mail"));
        return root;
    }

    private FileSystemNodeInfo createInfo(String path, long length, boolean process, String encoding) {
        FileSystemNodeInfo result = new FileSystemNodeInfo((FileInfo)new FileInfoMock(path, length), process, encoding);
        return result;
    }
}

