/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.plugin.AbstractDpkgPluginTest;
import net.sourceforge.javadpkg.plugin.cfg.DataEntry;
import net.sourceforge.javadpkg.plugin.impl.DataEntryNode;
import net.sourceforge.javadpkg.plugin.impl.DataEntryNodeTransformer;
import org.apache.maven.plugin.logging.Log;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mock;

public class DataEntryNodeTransformerTest
extends AbstractDpkgPluginTest {
    private static final String BASEDIR = "src/test/resources/net/sourceforge/javadpkg/plugin/";
    @Mock
    private Log log;

    @Test
    public void test() {
        List nodes;
        DataEntryNodeTransformer transformer = new DataEntryNodeTransformer();
        ArrayList<DataEntry> entries = new ArrayList<DataEntry>();
        try {
            transformer.transform(null, entries);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            transformer.transform(this.log, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        entries = new ArrayList();
        try {
            nodes = transformer.transform(this.log, entries);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        Assert.assertNotNull((Object)nodes);
        Assert.assertEquals((long)0L, (long)nodes.size());
        entries = new ArrayList();
        entries.add(new DataEntry(null, "/usr/local/test/", null, null, null, null, null, null, false, false, null));
        entries.add(new DataEntry("src/test/resources/net/sourceforge/javadpkg/plugin/program", "/usr/local/test/", null, null, null, null, null, Integer.valueOf(493), false, false, null));
        entries.add(new DataEntry(null, "/usr/local/test/other_program", "/usr/local/test/program", null, null, null, null, Integer.valueOf(493), false, false, null));
        entries.add(new DataEntry(null, "/usr/local/test/lib/", null, null, null, null, null, null, false, false, null));
        entries.add(new DataEntry("src/test/resources/net/sourceforge/javadpkg/plugin/lib/*.lib", "/usr/local/test/lib/", null, null, null, null, null, null, false, false, null));
        entries.add(new DataEntry(null, "/usr/local/test/lib64/", "/usr/local/test/lib/", null, null, null, null, null, false, false, null));
        entries.add(new DataEntry("src/test/resources/net/sourceforge/javadpkg/plugin/ext/*.dat", "/usr/local/test/lib/", null, null, null, null, null, null, false, false, null));
        entries.add(new DataEntry("src/test/resources/net/sourceforge/javadpkg/plugin/res/", "/usr/local/test/res/", null, null, null, null, null, null, true, false, null));
        entries.add(new DataEntry("src/test/resources/net/sourceforge/javadpkg/plugin/custom_images/*", "/usr/local/test/res/images/", null, null, null, null, null, null, false, false, null));
        entries.add(new DataEntry("src/test/resources/net/sourceforge/javadpkg/plugin/template/", "/usr/local/test/template/", null, null, null, null, null, null, true, false, null));
        entries.add(new DataEntry(null, "/usr/local/test/conf/", null, null, null, null, null, null, false, false, null));
        entries.add(new DataEntry("src/test/resources/net/sourceforge/javadpkg/plugin/conf/conf.default", "/usr/local/test/conf/conf", null, null, null, null, null, null, false, true, "UTF-8"));
        try {
            nodes = transformer.transform(this.log, entries);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        Assert.assertNotNull((Object)nodes);
        Assert.assertEquals((long)23L, (long)nodes.size());
        DataEntryNode node = (DataEntryNode)nodes.get(0);
        Assert.assertNotNull((Object)node);
        Assert.assertNull((Object)node.getSource());
        Assert.assertEquals((Object)"test", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(1);
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getSource());
        Assert.assertEquals((Object)new File("src/test/resources/net/sourceforge/javadpkg/plugin/program").getPath(), (Object)node.getSource().getPath());
        Assert.assertEquals((Object)"program", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertEquals((Object)493, (Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(2);
        Assert.assertNotNull((Object)node);
        Assert.assertNull((Object)node.getSource());
        Assert.assertEquals((Object)"other_program", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test", (Object)node.getParent().getAbsolutePath());
        Assert.assertEquals((Object)"/usr/local/test/program", (Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertEquals((Object)493, (Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(3);
        Assert.assertNotNull((Object)node);
        Assert.assertNull((Object)node.getSource());
        Assert.assertEquals((Object)"lib", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(4);
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getSource());
        Assert.assertEquals((Object)new File("src/test/resources/net/sourceforge/javadpkg/plugin/lib/library1.lib").getPath(), (Object)node.getSource().getPath());
        Assert.assertEquals((Object)"library1.lib", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/lib", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(5);
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getSource());
        Assert.assertEquals((Object)new File("src/test/resources/net/sourceforge/javadpkg/plugin/lib/library2.lib").getPath(), (Object)node.getSource().getPath());
        Assert.assertEquals((Object)"library2.lib", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/lib", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(6);
        Assert.assertNotNull((Object)node);
        Assert.assertNull((Object)node.getSource());
        Assert.assertEquals((Object)"lib64", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test", (Object)node.getParent().getAbsolutePath());
        Assert.assertEquals((Object)"/usr/local/test/lib/", (Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(7);
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getSource());
        Assert.assertEquals((Object)new File("src/test/resources/net/sourceforge/javadpkg/plugin/ext/ext1.dat").getPath(), (Object)node.getSource().getPath());
        Assert.assertEquals((Object)"ext1.dat", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/lib", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(8);
        Assert.assertNotNull((Object)node);
        Assert.assertNull((Object)node.getSource());
        Assert.assertEquals((Object)"res", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(9);
        Assert.assertNotNull((Object)node);
        Assert.assertNull((Object)node.getSource());
        Assert.assertEquals((Object)"images", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/res", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(10);
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getSource());
        Assert.assertEquals((Object)new File("src/test/resources/net/sourceforge/javadpkg/plugin/res/images/image1.img").getPath(), (Object)node.getSource().getPath());
        Assert.assertEquals((Object)"image1.img", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/res/images", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(11);
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getSource());
        Assert.assertEquals((Object)new File("src/test/resources/net/sourceforge/javadpkg/plugin/res/res1").getPath(), (Object)node.getSource().getPath());
        Assert.assertEquals((Object)"res1", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/res", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(12);
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getSource());
        Assert.assertEquals((Object)new File("src/test/resources/net/sourceforge/javadpkg/plugin/res/res2").getPath(), (Object)node.getSource().getPath());
        Assert.assertEquals((Object)"res2", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/res", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(13);
        Assert.assertNotNull((Object)node);
        Assert.assertNull((Object)node.getSource());
        Assert.assertEquals((Object)"text", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/res", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(14);
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getSource());
        Assert.assertEquals((Object)new File("src/test/resources/net/sourceforge/javadpkg/plugin/res/text/text1.txt").getPath(), (Object)node.getSource().getPath());
        Assert.assertEquals((Object)"text1.txt", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/res/text", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(15);
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getSource());
        Assert.assertEquals((Object)new File("src/test/resources/net/sourceforge/javadpkg/plugin/res/text/text2.txt").getPath(), (Object)node.getSource().getPath());
        Assert.assertEquals((Object)"text2.txt", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/res/text", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(16);
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getSource());
        Assert.assertEquals((Object)new File("src/test/resources/net/sourceforge/javadpkg/plugin/res/text/text3.txt").getPath(), (Object)node.getSource().getPath());
        Assert.assertEquals((Object)"text3.txt", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/res/text", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(17);
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getSource());
        Assert.assertEquals((Object)new File("src/test/resources/net/sourceforge/javadpkg/plugin/custom_images/image1.img").getPath(), (Object)node.getSource().getPath());
        Assert.assertEquals((Object)"image1.img", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/res/images", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(18);
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getSource());
        Assert.assertEquals((Object)new File("src/test/resources/net/sourceforge/javadpkg/plugin/custom_images/image2.img").getPath(), (Object)node.getSource().getPath());
        Assert.assertEquals((Object)"image2.img", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/res/images", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(19);
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getSource());
        Assert.assertEquals((Object)new File("src/test/resources/net/sourceforge/javadpkg/plugin/custom_images/image3.img").getPath(), (Object)node.getSource().getPath());
        Assert.assertEquals((Object)"image3.img", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/res/images", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(20);
        Assert.assertNotNull((Object)node);
        Assert.assertNull((Object)node.getSource());
        Assert.assertEquals((Object)"template", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(21);
        Assert.assertNotNull((Object)node);
        Assert.assertNull((Object)node.getSource());
        Assert.assertEquals((Object)"conf", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertFalse((boolean)node.isProcess());
        Assert.assertNull((Object)node.getEncoding());
        node = (DataEntryNode)nodes.get(22);
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getSource());
        Assert.assertEquals((Object)new File("src/test/resources/net/sourceforge/javadpkg/plugin/conf/conf.default").getPath(), (Object)node.getSource().getPath());
        Assert.assertEquals((Object)"conf", (Object)node.getName());
        Assert.assertNotNull((Object)node.getParent());
        Assert.assertEquals((Object)"/usr/local/test/conf", (Object)node.getParent().getAbsolutePath());
        Assert.assertNull((Object)node.getSymLink());
        Assert.assertNull((Object)node.getGroupId());
        Assert.assertNull((Object)node.getGroupName());
        Assert.assertNull((Object)node.getUserId());
        Assert.assertNull((Object)node.getUserName());
        Assert.assertNull((Object)node.getMode());
        Assert.assertTrue((boolean)node.isProcess());
        Assert.assertEquals((Object)"UTF-8", (Object)node.getEncoding());
    }
}

