/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.plugin;

import java.util.List;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.Architecture;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageVersion;
import net.sourceforge.javadpkg.control.impl.ArchitectureParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageNameParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionParserImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class AbstractDpkgPluginTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    protected static PackageName createPackageName(String name) {
        PackageName result;
        Assert.assertNotNull((Object)name);
        PackageNameParserImpl parser = new PackageNameParserImpl();
        ContextImpl context = new ContextImpl();
        try {
            result = parser.parsePackageName(name, (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create package name |" + name + "|: " + e.getMessage()));
            return null;
        }
        List warnings = context.getWarnings();
        Assert.assertEquals((String)("Found some warnings while creating package name |" + name + "|: " + warnings.size()), (long)0L, (long)warnings.size());
        return result;
    }

    protected static PackageVersion createPackageVersion(String version) {
        PackageVersion result;
        Assert.assertNotNull((Object)version);
        PackageVersionParserImpl parser = new PackageVersionParserImpl();
        ContextImpl context = new ContextImpl();
        try {
            result = parser.parsePackageVersion(version, (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create package version |" + version + "|: " + e.getMessage()));
            return null;
        }
        List warnings = context.getWarnings();
        Assert.assertEquals((String)("Found some warnings while creating package version |" + version + "|: " + warnings.size()), (long)0L, (long)warnings.size());
        return result;
    }

    protected static Architecture createArchitecture(String architecture) {
        Architecture result;
        Assert.assertNotNull((Object)architecture);
        ArchitectureParserImpl parser = new ArchitectureParserImpl();
        ContextImpl context = new ContextImpl();
        try {
            result = parser.parseArchitecture(architecture, (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create architecture |" + architecture + "|: " + e.getMessage()));
            return null;
        }
        List warnings = context.getWarnings();
        Assert.assertEquals((String)("Found some warnings while creating architecture |" + architecture + "|: " + warnings.size()), (long)0L, (long)warnings.size());
        return result;
    }
}

