/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.File;

import org.junit.Assert;
import org.junit.Test;

import net.sourceforge.javadpkg.control.Architecture;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageVersion;
import net.sourceforge.javadpkg.plugin.AbstractDpkgPluginTest;
import net.sourceforge.javadpkg.plugin.TargetFileBuilder;
import net.sourceforge.javadpkg.plugin.impl.TargetFileBuilderImpl;


/**
 * <p>
 * Performs some tests on the {@link TargetFileBuilderImpl} class.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 19.05.2016 by Gerrit Hohl
 */
public class TargetFileBuilderImplTest extends AbstractDpkgPluginTest {
	
	
	/**
	 * <p>
	 * Performs some tests on the {@link TargetFileBuilderImpl} class.
	 * </p>
	 */
	@Test
	public void test() {
		TargetFileBuilder builder;
		File targetDirectory, targetFile;
		PackageName name;
		PackageVersion version;
		Architecture architecture;


		builder = new TargetFileBuilderImpl();
		targetDirectory = new File(".");
		name = createPackageName("mypackage");
		version = createPackageVersion("1.0");
		architecture = createArchitecture("amd64");


		// --- Parameters ---
		try {
			builder.createTargetFile(null, name, version, architecture);
			Assert.fail("Expected an exception, but none was thrown.");
			return;
		} catch (IllegalArgumentException e) {
			// --- Expected exception. Do nothing. ---
		}
		try {
			builder.createTargetFile(targetDirectory, null, version, architecture);
			Assert.fail("Expected an exception, but none was thrown.");
			return;
		} catch (IllegalArgumentException e) {
			// --- Expected exception. Do nothing. ---
		}
		try {
			builder.createTargetFile(targetDirectory, name, null, architecture);
			Assert.fail("Expected an exception, but none was thrown.");
			return;
		} catch (IllegalArgumentException e) {
			// --- Expected exception. Do nothing. ---
		}
		try {
			builder.createTargetFile(targetDirectory, name, version, null);
			Assert.fail("Expected an exception, but none was thrown.");
			return;
		} catch (IllegalArgumentException e) {
			// --- Expected exception. Do nothing. ---
		}


		// --- Create ---
		targetFile = builder.createTargetFile(targetDirectory, name, version, architecture);
		Assert.assertNotNull(targetFile);
		Assert.assertEquals("mypackage_1.0_amd64.deb", targetFile.getName());
		Assert.assertEquals(".", targetFile.getParentFile().getPath());
	}
	
	
}
