/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.plugin.impl;

import java.io.File;

import net.sourceforge.javadpkg.plugin.impl.FileInfo;


/**
 * <p>
 * A mock implementation of the {@link FileInfo}.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 20.05.2016 by Gerrit Hohl
 */
public class FileInfoMock implements FileInfo {
	
	
	/** The absolute path. */
	private String	absolutePath;
	/** The length. */
	private long	length;
	
	
	/**
	 * <p>
	 * Creates a mock information about a reagular file.
	 * </p>
	 * 
	 * @param absolutePath
	 *            The absolute path.
	 * @param length
	 *            The length.
	 * @throws IllegalArgumentException
	 *             If the absolute path is <code>null</code> or the length is
	 *             less than <code>0</code>.
	 */
	public FileInfoMock(String absolutePath, long length) {
		super();

		if (absolutePath == null)
			throw new IllegalArgumentException("Argument absolutePath is null.");
		if (length < 0)
			throw new IllegalArgumentException("Argument length is less than 0: " + length);
		
		this.absolutePath = absolutePath;
		this.length = length;
	}


	@Override
	public File getFile() {
		return (new File(this.absolutePath));
	}
	
	
	@Override
	public String getAbsolutePath() {
		return this.absolutePath;
	}
	
	
	@Override
	public boolean exists() {
		return true;
	}
	
	
	@Override
	public boolean isFile() {
		return true;
	}
	
	
	@Override
	public boolean isDirectory() {
		return false;
	}
	
	
	@Override
	public long getLength() {
		return this.length;
	}
	
}
